/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.herbs;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseHerbBlock
extends CropBlock
implements EntityBlock {
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    protected static final VoxelShape[] SHAPE_BY_AGE;
    public static final Supplier<Map<Block, Set<Block>>> HERB_GROUND_MAP;

    public BaseHerbBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).randomTicks());
    }

    public BaseHerbBlock(BlockBehaviour.Properties prop) {
        super(prop);
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        Set<Block> blocks = HERB_GROUND_MAP.get().get((Object)this);
        return blocks != null && blocks.contains(groundState.getBlock());
    }

    public boolean canBloom(ServerLevel world, BlockState state) {
        return false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        int i = this.getAge(state);
        if (i < this.getMaxAge() && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(36) == 0 ? 1 : 0) != 0)) {
            level.setBlockAndUpdate(pos, this.getStateForAge(i + 1));
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = level.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)level, blockpos);
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return Items.AIR;
    }

    @NotNull
    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public int getMaxAge() {
        return 2;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[this.getAge(state)];
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : LibUtils.getTicker(type, (BlockEntityType)((BlockEntityType)ModBlocks.HERBS_ENTITY.get()), (level1, pos, state1, entity) -> {
            if (level1.getGameTime() % 20L == 2L) {
                int age = this.getAge(state1);
                if (age < 1) {
                    return;
                }
                if (this.canBloom((ServerLevel)level1, state1)) {
                    if (age != 2) {
                        level1.setBlockAndUpdate(pos, (BlockState)state1.setValue((Property)AGE, (Comparable)Integer.valueOf(2)));
                    }
                } else if (age == 2) {
                    level1.setBlockAndUpdate(pos, (BlockState)state1.setValue((Property)AGE, (Comparable)Integer.valueOf(1)));
                }
            }
        });
    }

    static {
        VoxelShape[] shapes = new VoxelShape[4];
        for (int i = 0; i < 4; ++i) {
            shapes[i] = BaseHerbBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(2 * (i + 1)), (double)16.0);
        }
        SHAPE_BY_AGE = shapes;
        HERB_GROUND_MAP = Suppliers.memoize(() -> new ImmutableMap.Builder().put((Object)((Block)ModBlocks.DAYBLOOM.get()), Set.of(Blocks.GRASS_BLOCK, (Block)NatureBlocks.HALLOW_GRASS_BLOCK.get())).put((Object)((Block)ModBlocks.MOONGLOW.get()), Set.of(Blocks.GRASS_BLOCK, Blocks.MOSS_BLOCK, (Block)NatureBlocks.JUNGLE_GRASS_BLOCK.get())).put((Object)((Block)NatureBlocks.STELLAR_BLOSSOM.get()), Set.of((Block)NatureBlocks.CLOUD_BLOCK.get(), (Block)NatureBlocks.RAIN_CLOUD_BLOCK.get())).put((Object)((Block)ModBlocks.SHIVERTHORN.get()), Set.of(Blocks.GRASS_BLOCK, Blocks.ICE, (Block)NatureBlocks.RED_ICE.get(), (Block)NatureBlocks.RED_PACKED_ICE.get(), (Block)NatureBlocks.PINK_PACKED_ICE.get(), (Block)NatureBlocks.PINK_ICE.get(), (Block)NatureBlocks.PURPLE_ICE.get(), (Block)NatureBlocks.PURPLE_PACKED_ICE.get())).put((Object)((Block)ModBlocks.BLINKROOT.get()), Set.of(Blocks.DIRT, Blocks.MUD, Blocks.STONE, Blocks.DEEPSLATE)).put((Object)((Block)ModBlocks.DEATHWEED.get()), Set.of((Block)NatureBlocks.CORRUPT_GRASS_BLOCK.get(), (Block)NatureBlocks.EBONSTONE.get(), (Block)NatureBlocks.CRIMSON_GRASS_BLOCK.get(), (Block)NatureBlocks.CRIMSTONE.get())).put((Object)((Block)ModBlocks.WATERLEAF.get()), Set.of(Blocks.SAND, Blocks.RED_SAND, (Block)NatureBlocks.PEARLSAND.get())).put((Object)((Block)ModBlocks.FIREBLOSSOM.get()), Set.of((Block)NatureBlocks.ASH_BLOCK.get(), (Block)NatureBlocks.ASH_GRASS_BLOCK.get())).build());
    }

    public static class BEntity
    extends BlockEntity {
        public BEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlocks.HERBS_ENTITY.get(), pos, state);
        }
    }
}

