/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.mixed.ILivingEntity;
import org.jetbrains.annotations.Nullable;

public class ThinIceBlock
extends IceBlock {
    public ThinIceBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_ICE));
    }

    public void updateEntityAfterFallOn(BlockGetter blockGetter, Entity entity) {
        LivingEntity living;
        if (!(entity instanceof LivingEntity) || !ILivingEntity.of(living = (LivingEntity)entity).confluence$isBreakEasyCrashBlock()) {
            super.updateEntityAfterFallOn(blockGetter, entity);
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack item) {
        player.awardStat(Stats.BLOCK_MINED.get((Object)this));
        player.causeFoodExhaustion(0.005f);
    }

    public static void fall(LivingEntity living, BlockPos blockPos) {
        Level level = living.level();
        if (!level.isClientSide) {
            BlockPos.betweenClosedStream((AABB)living.getBoundingBox().move(0.0, -0.5, 0.0)).forEach(pos -> {
                if (pos.equals((Object)blockPos) || level.getBlockState(pos).is(NatureBlocks.THIN_ICE_BLOCK)) {
                    level.destroyBlock(pos, true, (Entity)living);
                }
            });
        }
        ILivingEntity.of(living).confluence$setBreakEasyCrashBlock(true);
        living.setOnGround(false);
    }
}

