/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.init.block.NatureBlocks;

public class SmallCactusBlock
extends Block {
    protected static final VoxelShape SHAPE = SmallCactusBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public SmallCactusBlock() {
        super(BlockBehaviour.Properties.of().strength(0.4f).sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        return stateBelow.is(BlockTags.SAND) || stateBelow.is((Block)NatureBlocks.MOISTENED_SAND_BLOCK.get()) || stateBelow.is((Block)NatureBlocks.MOISTENED_RED_SAND_BLOCK.get());
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.hurt(level.damageSources().cactus(), 1.0f);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Player player = (Player)params.getParameter(LootContextParams.THIS_ENTITY);
        ItemStack tool = (ItemStack)params.getParameter(LootContextParams.TOOL);
        if (tool.getItem() instanceof ShearsItem) {
            return Collections.singletonList(new ItemStack((ItemLike)this));
        }
        RegistryAccess registryAccess = player.level().registryAccess();
        Holder.Reference silkTouchHolder = registryAccess.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH);
        int silkTouchLevel = EnchantmentHelper.getTagEnchantmentLevel((Holder)silkTouchHolder, (ItemStack)tool);
        if (silkTouchLevel > 0) {
            return Collections.singletonList(new ItemStack((ItemLike)this));
        }
        return Collections.emptyList();
    }
}

