/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.common.data.saved.MoonPhase;

public class ShimmerCrystalslBlock
extends Block {
    public static final BooleanProperty VISIBLE = StateProperties.VISIBLE;
    protected static final VoxelShape SHAPE = Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);

    public ShimmerCrystalslBlock() {
        super(BlockBehaviour.Properties.of().randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean shouldBeVisible;
        boolean isFullMoonNight = this.isFullMoonNight(level);
        boolean canSeeSky = level.canSeeSky(pos);
        boolean bl = shouldBeVisible = isFullMoonNight && canSeeSky;
        if ((Boolean)state.getValue((Property)VISIBLE) != shouldBeVisible) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(shouldBeVisible)));
        }
    }

    private boolean isFullMoonNight(ServerLevel level) {
        return LibDateUtils.isNight((Level)level) && MoonPhase.FULL_MOON.match((Level)level);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        return level.getBlockState(below).isFaceSturdy((BlockGetter)level, below, Direction.UP);
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return (Boolean)state.getValue((Property)VISIBLE) == false;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.getValue((Property)VISIBLE) != false ? SHAPE : Shapes.empty();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)VISIBLE) != false ? SHAPE : Shapes.empty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VISIBLE});
    }
}

