/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SandLayerBlock
extends Block {
    protected static final VoxelShape[] SHAPE_BY_LAYER;

    public SandLayerBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.SAND));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)BlockStateProperties.LAYERS)];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)BlockStateProperties.LAYERS) - 1];
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.getValue((Property)BlockStateProperties.LAYERS) == 8 ? 0.2f : 1.0f;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext UseContext) {
        int StackLayers = (Integer)state.getValue((Property)BlockStateProperties.LAYERS);
        if (UseContext.getItemInHand().is(this.asItem()) && StackLayers < 8) {
            if (UseContext.replacingClickedOnBlock()) {
                return UseContext.getClickedFace() == Direction.UP;
            }
            return true;
        }
        return StackLayers == 1;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.is((Block)this) && (Integer)state.getValue((Property)BlockStateProperties.LAYERS) < 8) {
            return (BlockState)state.cycle((Property)BlockStateProperties.LAYERS);
        }
        return super.getStateForPlacement(context);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.getBlockState(pos.below());
        return below.is((Block)this) || !below.isAir();
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos CurrentPos, BlockPos facingPos) {
        return state.canSurvive((LevelReader)level, CurrentPos) ? super.updateShape(state, facing, facingState, level, CurrentPos, facingPos) : Blocks.AIR.defaultBlockState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.LAYERS});
    }

    static {
        VoxelShape[] shapes = new VoxelShape[9];
        shapes[0] = Shapes.empty();
        for (int i = 1; i <= 8; ++i) {
            shapes[i] = SandLayerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(2 * i), (double)16.0);
        }
        SHAPE_BY_LAYER = shapes;
    }
}

