/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import org.confluence.mod.common.block.natural.DesertPlantBlock;
import org.confluence.mod.common.block.natural.SmallCactusBlock;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.worldgen.feature.PlantPatchFeature;

public class MoistSandBlock
extends Block
implements BonemealableBlock {
    private final Block TargetBlock;
    protected static final BooleanProperty NORTH = PipeBlock.NORTH;
    protected static final BooleanProperty EAST = PipeBlock.EAST;
    protected static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    protected static final BooleanProperty WEST = PipeBlock.WEST;
    protected static final BooleanProperty UP = PipeBlock.UP;
    protected static final BooleanProperty DOWN = PipeBlock.DOWN;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;

    public MoistSandBlock(BlockBehaviour.Properties properties, Block TargetSand) {
        super(properties.randomTicks().instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
        this.TargetBlock = TargetSand;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level blockgetter = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.below()).is(this.TargetBlock)))).setValue((Property)UP, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.above()).is(this.TargetBlock)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.north()).is(this.TargetBlock)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.east()).is(this.TargetBlock)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.south()).is(this.TargetBlock)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.west()).is(this.TargetBlock)));
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!facingState.is(this.TargetBlock)) {
            return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(false));
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.NORTH)), (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.SOUTH)), (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.EAST)), (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.WEST)), (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.UP)), (Comparable)((Boolean)state.getValue((Property)UP)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.DOWN)), (Comparable)((Boolean)state.getValue((Property)DOWN)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.NORTH)), (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.SOUTH)), (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.EAST)), (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.WEST)), (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.UP)), (Comparable)((Boolean)state.getValue((Property)UP)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.DOWN)), (Comparable)((Boolean)state.getValue((Property)DOWN)));
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos pos, BlockState state) {
        BlockPos targetPos = pos.above();
        PlantPatchFeature plantPatchFeature = new PlantPatchFeature(PlantPatchFeature.Config.CODEC);
        WeightedStateProvider plantProvider = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((DesertPlantBlock)((Object)NatureBlocks.SMALL_DESERT_PLANT.get())).defaultBlockState(), 50).add((Object)((SmallCactusBlock)((Object)NatureBlocks.SMALL_CACTUS.get())).defaultBlockState(), 30).add((Object)((DesertPlantBlock)((Object)NatureBlocks.BIG_DESERT_PLANT.get())).defaultBlockState(), 20).build());
        PlantPatchFeature.Config config = new PlantPatchFeature.Config((BlockStateProvider)plantProvider, (Block)NatureBlocks.BIG_DESERT_PLANT.get(), 1, 6, 128, List.of(serverLevel.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.DESERT)));
        if (!serverLevel.getBlockState(targetPos).isAir()) {
            return;
        }
        if (!this.isMoistSand(serverLevel.getBlockState(targetPos.below()))) {
            return;
        }
        plantPatchFeature.place((FeaturePlaceContext<PlantPatchFeature.Config>)new FeaturePlaceContext(Optional.empty(), (WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), randomSource, targetPos, (FeatureConfiguration)config));
    }

    private boolean isMoistSand(BlockState state) {
        return state.is((Block)NatureBlocks.MOISTENED_SAND_BLOCK.get()) || state.is((Block)NatureBlocks.MOISTENED_RED_SAND_BLOCK.get());
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level.dimension() == Level.NETHER) {
            if (state.is((Block)NatureBlocks.MOISTENED_RED_SAND_BLOCK.get())) {
                level.setBlock(pos, Blocks.RED_SAND.defaultBlockState(), 3);
            } else if (state.is((Block)NatureBlocks.MOISTENED_SAND_BLOCK.get())) {
                level.setBlock(pos, Blocks.SAND.defaultBlockState(), 3);
            }
            level.levelEvent(2009, pos, 0);
            level.playSound(null, pos, SoundEvents.WET_SPONGE_DRIES, SoundSource.BLOCKS, 1.0f, (1.0f + level.getRandom().nextFloat() * 0.2f) * 0.7f);
        }
    }
}

