/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.init.block.NatureBlocks;

public class LostPaperBlock
extends Block
implements EntityBlock {
    protected static final IntegerProperty LAYER = IntegerProperty.create((String)"layer", (int)0, (int)3);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    public LostPaperBlock() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYER, (Comparable)Integer.valueOf(0)));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext UseContext) {
        return !UseContext.isSecondaryUseActive() && UseContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)LAYER) < 3 || super.canBeReplaced(state, UseContext);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        int currentLayer;
        BlockState clickedBlockState = context.getLevel().getBlockState(context.getClickedPos());
        if (clickedBlockState.is((Block)this) && (currentLayer = ((Integer)clickedBlockState.getValue((Property)LAYER)).intValue()) < 3) {
            return (BlockState)clickedBlockState.setValue((Property)LAYER, (Comparable)Integer.valueOf(currentLayer + 1));
        }
        return this.defaultBlockState();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(pos.below());
        return belowState.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack tool) {
        if (blockEntity instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            int layer = (Integer)state.getValue((Property)LAYER);
            entity.dropLoot(level, pos, player, layer);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYER});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    public static class BEntity
    extends BlockEntity {
        private ResourceLocation lootTable = null;

        public BEntity(BlockPos pos, BlockState state) {
            super(NatureBlocks.LOST_PAPER_ENTITY.get(), pos, state);
        }

        public void setLootTable(ResourceLocation lootTable) {
            this.lootTable = lootTable;
            this.setChanged();
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            if (tag.contains("LootTable", 8)) {
                this.lootTable = ResourceLocation.tryParse((String)tag.getString("LootTable"));
            }
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            if (this.lootTable != null) {
                tag.putString("LootTable", this.lootTable.toString());
            }
        }

        public void dropLoot(Level level, BlockPos pos, Player player, int layer) {
            LootTable table;
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            int count = layer + 1;
            if (this.lootTable != null && (table = serverLevel.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable))) != LootTable.EMPTY) {
                LootParams params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).withLuck(player.getLuck()).create(LootContextParamSets.GIFT);
                for (int i = 0; i < count; ++i) {
                    for (ItemStack stack : table.getRandomItems(params)) {
                        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                    }
                }
                return;
            }
            ItemStack paperStack = new ItemStack((ItemLike)Items.PAPER, count);
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)paperStack);
        }
    }
}

