/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class HellStoneBlock
extends Block {
    private final boolean lava;

    public HellStoneBlock(boolean lava) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANCIENT_DEBRIS).mapColor(MapColor.COLOR_RED).lightLevel(value -> 10).strength(12.0f, 1200.0f).requiresCorrectToolForDrops());
        this.lava = lava;
    }

    public void stepOn(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().hotFloor(), 2.5f);
            entity.igniteForTicks(60);
        }
        super.stepOn(level, blockPos, blockState, entity);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        if (this.lava && !level.isClientSide && !player.hasInfiniteMaterials()) {
            level.setBlockAndUpdate(pos, Blocks.LAVA.defaultBlockState());
        }
    }
}

