/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.confluence.mod.common.init.ModSecretSeeds;

public class CrispyHoneyBlock
extends Block {
    public CrispyHoneyBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).strength(1.2f));
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        ServerLevel serverLevel;
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        if (level instanceof ServerLevel && (ModSecretSeeds.GET_FIXED_BOI.match(serverLevel = (ServerLevel)level) || ModSecretSeeds.FOR_THE_WORTHY.match(serverLevel)) && level.random.nextBoolean()) {
            level.setBlockAndUpdate(pos, Blocks.LAVA.defaultBlockState());
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (ModSecretSeeds.GET_FIXED_BOI.match(serverLevel = (ServerLevel)level) || ModSecretSeeds.FOR_THE_WORTHY.match(serverLevel))) {
            entity.igniteForSeconds(5.0f);
        }
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }
}

