/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.data.saved.KillBoard;

public class BaseTallPlantBlock
extends TallGrassBlock {
    public static final MapCodec<BaseTallPlantBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BaseTallPlantBlock.propertiesCodec(), (App)BuiltInRegistries.BLOCK.byNameCodec().listOf().fieldOf("ground").forGetter(block -> block.survive)).apply((Applicative)instance, BaseTallPlantBlock::new));
    protected final List<Block> survive;
    private transient Set<Block> cache;

    public BaseTallPlantBlock(Block ... survive) {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).replaceable(), Arrays.stream(survive).toList());
    }

    public BaseTallPlantBlock(BlockBehaviour.Properties prop, List<Block> survive) {
        super(prop);
        this.survive = survive;
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.cache == null) {
            this.cache = new HashSet<Block>(this.survive);
        }
        return this.cache.contains(state.getBlock());
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = level.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)level, blockpos) && level.isEmptyBlock(pos.above());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (this.canSurvive(this.defaultBlockState(), (LevelReader)level, pos)) {
            return this.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public BlockState updateShape(BlockState originState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        ISpreadable.Type type;
        BlockState after = super.updateShape(originState, facing, facingState, level, currentPos, facingPos);
        if (facing == Direction.UP && !facingState.isAir()) {
            return Blocks.AIR.defaultBlockState();
        }
        if (facing != Direction.DOWN) {
            return after;
        }
        Block block = facingState.getBlock();
        if (block instanceof ISpreadable) {
            ISpreadable spreadable = (ISpreadable)block;
            type = spreadable.getSpreadType();
        } else {
            type = ISpreadable.Type.PURE;
        }
        ISpreadable.Type type2 = type;
        BlockState transformResult = type2.getNotNull(originState, KillBoard.INSTANCE.getGamePhase().isHardmode());
        return transformResult.canSurvive((LevelReader)level, currentPos) ? transformResult : Blocks.AIR.defaultBlockState();
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos abovePos;
        BlockState aboveState;
        if (!level.isClientSide && (aboveState = level.getBlockState(abovePos = pos.above())).getBlock() == this) {
            level.setBlock(abovePos, Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent(player, 2001, abovePos, Block.getId((BlockState)aboveState));
        }
        super.playerWillDestroy(level, pos, state, player);
        return state;
    }
}

