/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.init.ModTags;

public class BaseDroopingPlantsHeadBlock
extends GrowingPlantHeadBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<BaseDroopingPlantsHeadBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("side").forGetter(block -> block.side), (App)Codec.INT.fieldOf("max_age").forGetter(block -> block.maxAge), (App)Codec.BOOL.fieldOf("is_natural_growth").forGetter(block -> block.isNaturalGrowth), (App)Codec.BOOL.fieldOf("is_climbable").forGetter(block -> block.isClimbable), (App)BuiltInRegistries.BLOCK.byNameCodec().listOf().fieldOf("attached_block").forGetter(block -> block.attachedBlock)).apply((Applicative)instance, BaseDroopingPlantsHeadBlock::new));
    public static final int DEFAULT_MAX_AGE = 25;
    protected static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected final int side;
    protected final int maxAge;
    protected final boolean isNaturalGrowth;
    protected final boolean isClimbable;
    protected final List<Block> attachedBlock;
    private final Set<Block> attachedBlockCache;

    public BaseDroopingPlantsHeadBlock(int side, boolean isNaturalGrowth, boolean isClimbable) {
        this(side, 25, isNaturalGrowth, isClimbable, List.of());
    }

    public BaseDroopingPlantsHeadBlock(int side, boolean isNaturalGrowth, boolean isClimbable, List<Block> attachedBlock) {
        this(side, 25, isNaturalGrowth, isClimbable, attachedBlock);
    }

    public BaseDroopingPlantsHeadBlock(int side, int maxAge, boolean isNaturalGrowth, boolean isClimbable, List<Block> attachedBlock) {
        super(BlockBehaviour.Properties.of().noCollission().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY), Direction.DOWN, BaseDroopingPlantsHeadBlock.createShape(side), false, 0.1);
        this.side = side;
        this.maxAge = maxAge;
        this.isNaturalGrowth = isNaturalGrowth;
        this.isClimbable = isClimbable;
        this.attachedBlock = attachedBlock;
        this.attachedBlockCache = Set.copyOf(attachedBlock);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape createShape(int side) {
        double margin = (16.0 - (double)side) / 2.0;
        return Block.box((double)margin, (double)0.0, (double)margin, (double)(16.0 - margin), (double)16.0, (double)(16.0 - margin));
    }

    protected MapCodec<? extends BaseDroopingPlantsHeadBlock> codec() {
        return CODEC;
    }

    protected Block getBodyBlock() {
        return this;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return NetherVines.getBlocksToGrowWhenBonemealed((RandomSource)random);
    }

    protected boolean canGrowInto(BlockState state) {
        return NetherVines.isValidGrowthState((BlockState)state);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.isNaturalGrowth || (Integer)state.getValue((Property)AGE) < this.maxAge;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            state = this.defaultBlockState();
        }
        boolean isWater = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater))).setValue((Property)AGE, (Comparable)Integer.valueOf(context.getLevel().getRandom().nextInt(Math.max(1, this.maxAge))));
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos growPos;
        if ((Integer)state.getValue((Property)AGE) < this.maxAge && random.nextDouble() < 0.1 && this.canGrowInto(level.getBlockState(growPos = pos.relative(this.growthDirection)))) {
            level.setBlockAndUpdate(growPos, this.getGrowIntoState(state, level.random));
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos supportPos = pos.above();
        BlockState supportState = level.getBlockState(supportPos);
        if (supportState.is((Block)this)) {
            return true;
        }
        if (this.attachedBlockCache.isEmpty()) {
            return supportState.is(ModTags.Blocks.DROOPING_VINE_CAN_SURVIVE);
        }
        return this.attachedBlockCache.contains(supportState.getBlock());
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return this.isClimbable;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }
}

