/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;
import org.confluence.mod.common.init.block.NatureBlocks;

public abstract class BaseCropBlock
extends CropBlock {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)7);
    public static final int MAX_AGE = 7;

    public BaseCropBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected abstract ItemLike getBaseSeedId();

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{AGE});
    }

    public abstract Set<Block> getCanPlaceBlocks();

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCanPlaceBlocks().contains(state.getBlock());
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockState belowState = level.getBlockState(below);
        return this.mayPlaceOn(belowState, (BlockGetter)level, below);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i;
        if (!level.isAreaLoaded(pos, 3)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge()) {
            float f = BaseCropBlock.getGrowthSpeed((BlockState)state, (BlockGetter)level, (BlockPos)pos);
            BlockState belowState = level.getBlockState(pos.below());
            if (belowState.is((Block)NatureBlocks.RAIN_CLOUD_BLOCK.get())) {
                f *= 3.0f;
            }
            if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                level.setBlock(pos, this.getStateForAge(i + 1), 2);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }
}

