/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.network;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.block.functional.network.NetworkNode;

public class Network {
    private final int color;
    private final Set<NetworkNode> nodes;
    private boolean signal;
    boolean schedule;

    public Network(int color) {
        this.color = color;
        this.nodes = new HashSet<NetworkNode>();
        this.signal = false;
        this.schedule = false;
    }

    public int getColor() {
        return this.color;
    }

    public Set<NetworkNode> getNodes() {
        return this.nodes;
    }

    public void addNode(NetworkNode node) {
        this.nodes.add(node);
    }

    public void removeNode(NetworkNode node) {
        this.nodes.remove(node);
    }

    public void setSignal(boolean signal) {
        this.signal = signal;
    }

    public boolean hasSignal() {
        return this.signal;
    }

    public boolean calculateSignal() {
        this.signal = this.nodes.stream().anyMatch(node -> {
            BlockState blockState = node.getState();
            return blockState.hasProperty((Property)StateProperties.SIGNAL) && (Boolean)blockState.getValue((Property)StateProperties.SIGNAL) != false;
        });
        return this.signal;
    }

    public void destroy() {
        for (NetworkNode node : this.nodes) {
            node.removeNetwork(this.color);
        }
        this.nodes.clear();
    }

    private static Network mergeInPrior(Network n1, Network n2) {
        for (NetworkNode node : n2.nodes) {
            node.addNetwork(n1);
        }
        n1.nodes.addAll(n2.nodes);
        n2.nodes.clear();
        return n1;
    }

    public static Network merge(Network n1, Network n2) {
        if (n1.nodes.size() >= n2.nodes.size()) {
            return Network.mergeInPrior(n1, n2);
        }
        return Network.mergeInPrior(n2, n1);
    }
}

