/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.menu.SolidifierMenu;
import org.jetbrains.annotations.Nullable;

public class SolidifierBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<SolidifierBlock> CODEC = SolidifierBlock.simpleCodec(SolidifierBlock::new);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)SolidifierBlock.box((double)4.5, (double)2.0, (double)14.0, (double)11.5, (double)9.0, (double)15.0), (VoxelShape[])new VoxelShape[]{SolidifierBlock.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)11.0, (double)14.0), SolidifierBlock.box((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)2.0, (double)13.0), SolidifierBlock.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)2.0, (double)5.0), SolidifierBlock.box((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)19.0, (double)10.0)}), Shapes.or((VoxelShape)SolidifierBlock.box((double)1.0, (double)2.0, (double)4.5, (double)2.0, (double)9.0, (double)11.5), (VoxelShape[])new VoxelShape[]{SolidifierBlock.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)11.0, (double)15.0), SolidifierBlock.box((double)11.0, (double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)16.0), SolidifierBlock.box((double)3.0, (double)0.0, (double)0.0, (double)5.0, (double)2.0, (double)16.0), SolidifierBlock.box((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)19.0, (double)10.0)}), Shapes.or((VoxelShape)SolidifierBlock.box((double)4.5, (double)2.0, (double)1.0, (double)11.5, (double)9.0, (double)2.0), (VoxelShape[])new VoxelShape[]{SolidifierBlock.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)11.0, (double)14.0), SolidifierBlock.box((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)2.0, (double)13.0), SolidifierBlock.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)2.0, (double)5.0), SolidifierBlock.box((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)19.0, (double)10.0)}), Shapes.or((VoxelShape)SolidifierBlock.box((double)14.0, (double)2.0, (double)4.5, (double)15.0, (double)9.0, (double)11.5), (VoxelShape[])new VoxelShape[]{SolidifierBlock.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)11.0, (double)15.0), SolidifierBlock.box((double)11.0, (double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)16.0), SolidifierBlock.box((double)3.0, (double)0.0, (double)0.0, (double)5.0, (double)2.0, (double)16.0), SolidifierBlock.box((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)19.0, (double)10.0)})};

    public SolidifierBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue((Property)FACING)).get2DDataValue()];
    }

    protected MapCodec<SolidifierBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((containerId, inventory, player) -> new SolidifierMenu(containerId, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), (Component)Component.translatable((String)"container.confluence.solidifier"));
    }
}

