/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.HorizontalDirectionalWithHorizontalTwoPartBlock;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.menu.LoomMenu;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LoomBlock
extends HorizontalDirectionalWithHorizontalTwoPartBlock
implements EntityBlock {
    private static final VoxelShape BASE_SHAPE_SOUTH = LoomBlock.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE_WEST = LoomBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape BASE_SHAPE_NORTH = LoomBlock.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE_EAST = LoomBlock.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape RIGHT_SHAPE_SOUTH = LoomBlock.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape RIGHT_SHAPE_WEST = LoomBlock.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape RIGHT_SHAPE_NORTH = LoomBlock.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0);
    private static final VoxelShape RIGHT_SHAPE_EAST = LoomBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)16.0);
    private static final VoxelShape[] BASE_SHAPES = new VoxelShape[]{BASE_SHAPE_SOUTH, BASE_SHAPE_WEST, BASE_SHAPE_NORTH, BASE_SHAPE_EAST};
    private static final VoxelShape[] RIGHT_SHAPES = new VoxelShape[]{RIGHT_SHAPE_SOUTH, RIGHT_SHAPE_WEST, RIGHT_SHAPE_NORTH, RIGHT_SHAPE_EAST};

    public LoomBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LOOM));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int index = ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        return ((StateProperties.HorizontalTwoPart)state.getValue((Property)PART)).isBase() ? BASE_SHAPES[index] : RIGHT_SHAPES[index];
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((containerId, inventory, player) -> new LoomMenu(containerId, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), (Component)Component.translatable((String)"container.confluence.loom"));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    public static class BEntity
    extends BlockEntity
    implements GeoBlockEntity {
        private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        public final boolean isBase;

        public BEntity(BlockPos pos, BlockState blockState) {
            super(FunctionalBlocks.LOOM_ENTITY.get(), pos, blockState);
            this.isBase = ((StateProperties.HorizontalTwoPart)blockState.getValue((Property)HorizontalDirectionalWithHorizontalTwoPartBlock.PART)).isBase();
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
            RawAnimation running = RawAnimation.begin().thenLoop("running");
            controllers.add(new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(running)));
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.cache;
        }
    }
}

