/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.menu.HardmodeAnvilMenu;
import org.jetbrains.annotations.Nullable;

public class HardmodeAnvilBlock
extends FallingBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final MapCodec<HardmodeAnvilBlock> CODEC = HardmodeAnvilBlock.simpleCodec(HardmodeAnvilBlock::new);
    private static final VoxelShape X_AXIS_SHAPE = Shapes.or((VoxelShape)HardmodeAnvilBlock.box((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)4.0, (double)13.0), (VoxelShape[])new VoxelShape[]{HardmodeAnvilBlock.box((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), HardmodeAnvilBlock.box((double)3.5, (double)8.0, (double)2.0, (double)12.5, (double)14.0, (double)14.0), HardmodeAnvilBlock.box((double)4.5, (double)9.0, (double)-1.0, (double)11.5, (double)14.0, (double)17.0)});
    private static final VoxelShape Z_AXIS_SHAPE = Shapes.or((VoxelShape)HardmodeAnvilBlock.box((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)4.0, (double)12.0), (VoxelShape[])new VoxelShape[]{HardmodeAnvilBlock.box((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), HardmodeAnvilBlock.box((double)2.0, (double)8.0, (double)3.5, (double)14.0, (double)14.0, (double)12.5), HardmodeAnvilBlock.box((double)-1.0, (double)9.0, (double)4.5, (double)17.0, (double)14.0, (double)11.5)});

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return direction.getAxis() == Direction.Axis.Z ? Z_AXIS_SHAPE : X_AXIS_SHAPE;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public HardmodeAnvilBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected MapCodec<HardmodeAnvilBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((containerId, inventory, player) -> new HardmodeAnvilMenu(containerId, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), (Component)Component.translatable((String)("container.confluence." + BuiltInRegistries.BLOCK.getKey((Object)this).getPath())));
    }
}

