/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.boulder;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.entity.projectile.boulder.AbstractBoulderEntity;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBoulderBlock<T extends AbstractBoulderEntity>
extends AbstractMechanicalBlock {
    private final BoulderEntityFactory<T> createEntityFactory;
    private final BoulderEntity.Builder builder;

    public AbstractBoulderBlock(BoulderEntityFactory<T> createEntityFactory) {
        this(BlockBehaviour.Properties.of(), createEntityFactory, BoulderEntity.Builder.of());
    }

    public AbstractBoulderBlock(BoulderEntityFactory<T> createEntityFactory, BoulderEntity.Builder builder) {
        this(BlockBehaviour.Properties.of(), createEntityFactory, builder);
    }

    public AbstractBoulderBlock(BlockBehaviour.Properties properties, BoulderEntityFactory<T> createEntityFactory) {
        this(properties, createEntityFactory, BoulderEntity.Builder.of());
    }

    public AbstractBoulderBlock(BlockBehaviour.Properties properties, BoulderEntityFactory<T> createEntityFactory, BoulderEntity.Builder builder) {
        super(properties);
        this.createEntityFactory = createEntityFactory;
        this.builder = builder;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        BlockPos relative = pos.relative(Direction.DOWN);
        BlockState blockState = level.getBlockState(relative);
        if (!blockState.isAir() || blockState.isFaceSturdy((BlockGetter)level, relative, Direction.UP)) {
            return;
        }
        level.removeBlock(pos, false);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return true;
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        level.removeBlock(hit.getBlockPos(), false);
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        this.summon(level, pos, state, entity1 -> level.getNearestPlayer((Entity)entity1, (double)entity1.getTrackingRange()));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (!(pLevel instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        BlockState below = pLevel.getBlockState(pPos.below());
        if (!below.isAir()) {
            return;
        }
        if (pLevel.hasNeighborSignal(pPos)) {
            this.execute(pState, serverLevel, pPos, true);
            return;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof INetworkEntity)) {
            return;
        }
        INetworkEntity iNetworkEntity = (INetworkEntity)blockEntity;
        this.onExecute(pState, serverLevel, pPos, -1, iNetworkEntity);
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        level.removeBlock(pos, false);
    }

    protected void summon(Level level, BlockPos pos, BlockState blockState, Function<T, Player> function) {
        T entity = this.createEntityFactory.create(level, pos.getBottomCenter(), blockState, this.builder);
        if (!level.getBlockState(pos.below()).isAir()) {
            ((AbstractBoulderEntity)((Object)entity)).setTracking(true);
            ((AbstractBoulderEntity)((Object)entity)).targetPlayer(function.apply(entity));
        }
        level.addFreshEntity(entity);
    }

    @FunctionalInterface
    public static interface BoulderEntityFactory<T extends AbstractBoulderEntity> {
        public T create(Level var1, Vec3 var2, BlockState var3, BoulderEntity.Builder var4);
    }
}

