/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.client.handler.WeatherHandler;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;

public class WeatherVaneBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = WeatherVaneBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0);

    public WeatherVaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? LibUtils.getTicker(blockEntityType, FunctionalBlocks.WEATHER_VANE_ENTITY.get(), BEntity::clientTick) : null;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public static class BEntity
    extends BlockEntity {
        private static final float INACCURACY = 0.015000001f;
        private final Vector2f lastWindSpeed = new Vector2f();
        private int shakeTime = 20;
        private float targetRotation = 0.0f;
        public float rotationO = 0.0f;
        public float rotation = 0.0f;
        public float shakeO = 0.0f;
        public float shake = 0.0f;

        public BEntity(BlockPos pos, BlockState blockState) {
            super(FunctionalBlocks.WEATHER_VANE_ENTITY.get(), pos, blockState);
        }

        public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, BEntity entity) {
            float windSpeedX = WeatherHandler.getWindSpeedX();
            float windSpeedZ = WeatherHandler.getWindSpeedZ();
            if (entity.lastWindSpeed.x != windSpeedX || entity.lastWindSpeed.y != windSpeedZ) {
                entity.lastWindSpeed.set(windSpeedX, windSpeedZ).normalize();
                float target = 1.5707964f - (float)Mth.atan2((double)entity.lastWindSpeed.y, (double)entity.lastWindSpeed.x);
                entity.shakeTime = target > entity.targetRotation ? Mth.abs((int)((int)((entity.targetRotation - target) * 10.0f))) : Mth.abs((int)((int)((target - entity.targetRotation) * 10.0f)));
                entity.targetRotation = target;
            }
            if (entity.rotation == entity.targetRotation) {
                if (entity.shakeTime > 0) {
                    entity.shakeO = entity.shake;
                    entity.shake = Mth.sin((float)((float)(level.getGameTime() % 360L) * ((float)Math.PI / 180) * 30.0f)) * ((float)entity.shakeTime * 0.015000001f);
                    --entity.shakeTime;
                } else {
                    entity.shake = 0.0f;
                    entity.shakeO = 0.0f;
                }
            } else {
                entity.rotationO = entity.rotation;
                entity.shakeO = entity.shake;
                float delta = entity.targetRotation - entity.rotation;
                if (Mth.abs((float)delta) > 0.15707964f) {
                    if (entity.targetRotation > entity.rotation) {
                        entity.shake = delta * 0.2f;
                        entity.rotation += entity.shake;
                    } else {
                        entity.shake = (entity.rotation - entity.targetRotation) * 0.2f;
                        entity.rotation -= entity.shake;
                    }
                } else {
                    entity.rotationO = entity.targetRotation;
                    entity.rotation = entity.targetRotation;
                }
            }
        }
    }
}

