/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.Nullable;

public class TimersBlock
extends AbstractMechanicalBlock {
    private final int duration;

    public TimersBlock(int duration) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COMPARATOR));
        if (duration <= 0) {
            throw new RuntimeException("Duration cannot less equal 0!");
        }
        this.duration = duration;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{StateProperties.DRIVE, StateProperties.SIGNAL});
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (this.skipInteraction(pPlayer.getMainHandItem())) {
            return InteractionResult.PASS;
        }
        if (!pLevel.isClientSide && pPlayer.isCrouching()) {
            if (!((Boolean)(pState = (BlockState)pState.cycle((Property)StateProperties.DRIVE)).getValue((Property)StateProperties.DRIVE)).booleanValue()) {
                pState = (BlockState)pState.setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(false));
                this.execute(pState, (ServerLevel)pLevel, pPos, false);
            }
            pLevel.setBlockAndUpdate(pPos, pState);
        }
        return InteractionResult.SUCCESS;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (pLevel.isClientSide && pLevel.hasNeighborSignal(pPos)) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.cycle((Property)StateProperties.DRIVE));
        }
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)Block.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.5, (double)4.0, (double)0.5, (double)15.5, (double)11.0, (double)15.5), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0)});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return LibUtils.getTicker(pBlockEntityType, FunctionalBlocks.MECHANICAL_BLOCK_ENTITY.get(), TimersBlock::timer);
    }

    private static void timer(Level level, BlockPos blockPos, BlockState blockState, AbstractMechanicalBlock.BEntity entity) {
        if (level.isClientSide || !((Boolean)blockState.getValue((Property)StateProperties.DRIVE)).booleanValue()) {
            return;
        }
        TimersBlock timersBlock = (TimersBlock)blockState.getBlock();
        if ((level.getGameTime() + (long)entity.getOrCreateNetworkNode().getId()) % (long)timersBlock.duration == 0L) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(true)));
            timersBlock.execute(blockState, (ServerLevel)level, blockPos, true);
        } else if (((Boolean)blockState.getValue((Property)StateProperties.SIGNAL)).booleanValue()) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(false)));
            timersBlock.execute(blockState, (ServerLevel)level, blockPos, false);
        }
    }
}

