/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.apache.commons.lang3.mutable.MutableInt;
import org.confluence.mod.common.block.functional.AbstractDispenserMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.entity.projectile.SuperSpikyBallProjectile;

public class SpikyBallTrapBlock
extends AbstractDispenserMechanicalBlock {
    private static final double sigma = Mth.square((double)6.25);

    public SpikyBallTrapBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    protected boolean behaviour(BlockState pState, ServerLevel pLevel, BlockPos pPos, int pColor, INetworkEntity pEntity) {
        MutableInt value = new MutableInt();
        pLevel.getProfiler().incrementCounter("getEntities");
        pLevel.getEntities().get(EntityTypeTest.forClass(SuperSpikyBallProjectile.class), projectile -> {
            double sqr = pPos.distToCenterSqr((Position)projectile.position());
            int newValue = value.intValue();
            newValue = sqr <= sigma ? (newValue += 50) : (sqr <= sigma * 2.0 ? (newValue += 15) : (sqr <= sigma * 4.0 ? (newValue += 10) : (sqr <= sigma * 6.0 ? (newValue += 8) : (sqr <= sigma * 8.0 ? (newValue += 6) : (sqr <= sigma * 10.0 ? (newValue += 5) : (sqr <= sigma * 14.0 ? (newValue += 4) : (sqr <= sigma * 18.0 ? (newValue += 3) : (sqr <= sigma * 24.0 ? (newValue += 2) : ++newValue))))))));
            if (newValue >= 200) {
                return AbortableIterationConsumer.Continuation.ABORT;
            }
            value.setValue(newValue);
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
        if (value.intValue() >= 200) {
            return false;
        }
        Direction direction = (Direction)pState.getValue((Property)FACING);
        double x = (double)pPos.getX() + 0.5 + 1.7 * (double)direction.getStepX();
        double y = (double)pPos.getY() + 0.5 + 1.7 * (double)direction.getStepY();
        double z = (double)pPos.getZ() + 0.5 + 1.7 * (double)direction.getStepZ();
        SuperSpikyBallProjectile projectile2 = new SuperSpikyBallProjectile((Level)pLevel);
        projectile2.setPos(x, y, z);
        projectile2.shoot((double)direction.getStepX() + Mth.nextDouble((RandomSource)pLevel.random, (double)-0.1, (double)0.1), (double)direction.getStepY() + Mth.nextDouble((RandomSource)pLevel.random, (double)-0.1, (double)0.1), (double)direction.getStepZ() + Mth.nextDouble((RandomSource)pLevel.random, (double)-0.1, (double)0.1), 1.0f, 0.0f);
        return pLevel.addFreshEntity((Entity)projectile2);
    }

    @Override
    protected int delay() {
        return 100;
    }
}

