/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import org.confluence.lib.util.ReturnException;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.mixin.accessor.LevelAccessor;

public class SignalPressurePlateBlock
extends PressurePlateBlock
implements EntityBlock,
INetworkBlock {
    public SignalPressurePlateBlock(BlockSetType type, BlockBehaviour.Properties properties) {
        super(type, properties);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        this.onNodeRemove(pState, pLevel, pPos, pNewState);
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i = this.getSignalForState(pState);
        int j = this.getSignalStrength((Level)pLevel, pPos);
        if (i > 0 && i != j) {
            this.execute(pState, pLevel, pPos, j > 0);
        }
        super.tick(pState, pLevel, pPos, pRandom);
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.entityInside(pState, pLevel, pPos, pEntity);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            int i = this.getSignalForState(pState);
            if (i == 0) {
                this.execute(pState, serverLevel, pPos, true);
            }
        }
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AbstractMechanicalBlock.BEntity(blockPos, blockState);
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
    }

    protected int getSignalStrength(Level level, BlockPos pos) {
        Predicate<Entity> test = EntitySelector.NO_SPECTATORS.and(entity -> !entity.isIgnoringBlockTriggers() && (this.type.pressurePlateSensitivity() != BlockSetType.PressurePlateSensitivity.MOBS || entity instanceof LivingEntity));
        try {
            ((LevelAccessor)level).callGetEntities().get(TOUCH_AABB.move(pos), entity -> {
                if (test.test((Entity)entity)) {
                    throw new ReturnException();
                }
            });
        }
        catch (ReturnException e) {
            return 15;
        }
        return 0;
    }
}

