/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SculkTrapBlock
extends SculkSensorBlock {
    public SculkTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void activate(@Nullable Entity entity, Level level, BlockPos pos, BlockState state, int power, int frequency) {
        super.activate(entity, level, pos, state, power, frequency);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SpawnUtil.trySpawnMob((EntityType)EntityType.WARDEN, (MobSpawnType)MobSpawnType.TRIGGERED, (ServerLevel)serverLevel, (BlockPos)pos, (int)20, (int)5, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.ON_TOP_OF_COLLIDER).ifPresent(warden -> {
                warden.addTag("confluence:no_drops");
                SoundEvent soundevent = SoundEvents.WARDEN_LISTENING_ANGRY;
                int i = pos.getX() + Mth.randomBetweenInclusive((RandomSource)level.random, (int)-10, (int)10);
                int j = pos.getY() + Mth.randomBetweenInclusive((RandomSource)level.random, (int)-10, (int)10);
                int k = pos.getZ() + Mth.randomBetweenInclusive((RandomSource)level.random, (int)-10, (int)10);
                level.playSound(null, (double)i, (double)j, (double)k, soundevent, SoundSource.HOSTILE, 5.0f, 1.0f);
            });
        }
    }
}

