/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.jetbrains.annotations.Nullable;

public class GeyserBlock
extends AbstractMechanicalBlock {
    public static final BooleanProperty IS_FLOOR = BooleanProperty.create((String)"is_floor");
    private static final VoxelShape SHAPE_FLOOR = Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.9375);
    private static final VoxelShape SHAPE_CEIL = Shapes.box((double)0.0625, (double)0.5, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375);

    public GeyserBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{IS_FLOOR, StateProperties.DRIVE});
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (!pLevel.isClientSide) {
            this.execute(pState, (ServerLevel)pLevel, pPos, pLevel.hasNeighborSignal(pPos));
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getNearestLookingVerticalDirection();
        return (BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(direction == Direction.DOWN));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos below = pPos.below();
        BlockPos above = pPos.above();
        return pLevel.getBlockState(below).isFaceSturdy((BlockGetter)pLevel, below, Direction.UP) || pLevel.getBlockState(above).isFaceSturdy((BlockGetter)pLevel, above, Direction.DOWN);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.getValue((Property)IS_FLOOR) != false ? SHAPE_FLOOR : SHAPE_CEIL;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof AbstractMechanicalBlock.BEntity) {
            AbstractMechanicalBlock.BEntity entity = (AbstractMechanicalBlock.BEntity)blockEntity;
            this.onExecute(pState, (ServerLevel)pLevel, pPos, -1, entity);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        if (((Boolean)state.getValue((Property)StateProperties.DRIVE)).booleanValue()) {
            return;
        }
        int bx = pos.getX();
        int by = pos.getY();
        int bz = pos.getZ();
        double offsetY = (Boolean)state.getValue((Property)IS_FLOOR) != false ? 12.0 : -12.0;
        level.getEntities((Entity)null, new AABB((double)bx, (double)by, (double)bz, (double)bx + 1.0, (double)by + offsetY, (double)bz + 1.0), entity -> entity instanceof LivingEntity).forEach(entity -> entity.hurt(level.damageSources().lava(), 4.0f));
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(true)));
        level.scheduleTick(pos, (Block)this, 66);
    }
}

