/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.jetbrains.annotations.Nullable;

public class BehaviourPressurePlateBlock
extends BasePressurePlateBlock
implements EntityBlock,
INetworkBlock {
    public static final MapCodec<BehaviourPressurePlateBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Behaviour.CODEC.fieldOf("behaviour").forGetter(block -> block.behaviour), (App)BehaviourPressurePlateBlock.propertiesCodec(), (App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(block -> block.type)).apply((Applicative)instance, BehaviourPressurePlateBlock::new));
    public static final Behaviour PLAYER = Behaviour.register(Confluence.asResource("player"), new Behaviour(){

        @Override
        protected int getSignalStrength(Level level, BlockPos blockPos) {
            AABB aabb = TOUCH_AABB.move(blockPos);
            for (Player player : level.players()) {
                if (!aabb.contains(player.position())) continue;
                return 15;
            }
            return 0;
        }
    });
    private final Behaviour behaviour;

    public BehaviourPressurePlateBlock(Behaviour behaviour, BlockBehaviour.Properties pProperties, BlockSetType pType) {
        super(pProperties, pType);
        this.behaviour = behaviour;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{BlockStateProperties.POWERED});
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        this.onNodeRemove(pState, pLevel, pPos, pNewState);
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AbstractMechanicalBlock.BEntity(blockPos, blockState);
    }

    protected MapCodec<BehaviourPressurePlateBlock> codec() {
        return CODEC;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i = this.getSignalForState(pState);
        int j = this.getSignalStrength((Level)pLevel, pPos);
        if (i > 0 && i != j) {
            this.execute(pState, pLevel, pPos, j > 0);
        }
        super.tick(pState, pLevel, pPos, pRandom);
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        super.entityInside(pState, pLevel, pPos, pEntity);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            int i = this.getSignalForState(pState);
            if (i == 0) {
                this.execute(pState, serverLevel, pPos, true);
            }
        }
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        this.behaviour.onExecute(state, level, pos, color, networkEntity);
    }

    @Override
    public void onUnExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        this.behaviour.onUnExecute(state, level, pos, color, networkEntity);
    }

    protected int getSignalStrength(Level level, BlockPos blockPos) {
        return this.behaviour.getSignalStrength(level, blockPos);
    }

    protected int getSignalForState(BlockState blockState) {
        return this.behaviour.getSignalForState(blockState);
    }

    protected BlockState setSignalForState(BlockState blockState, int i) {
        return this.behaviour.setSignalForState(blockState, i);
    }

    public static abstract class Behaviour {
        private static final BiMap<ResourceLocation, Behaviour> MAP = HashBiMap.create();
        public static final Codec<Behaviour> CODEC = ResourceLocation.CODEC.xmap(arg_0 -> MAP.get(arg_0), arg_0 -> MAP.inverse().get(arg_0));

        public static Behaviour register(ResourceLocation id, Behaviour behaviour) {
            MAP.put((Object)id, (Object)behaviour);
            return behaviour;
        }

        public void onExecute(BlockState pState, ServerLevel pLevel, BlockPos pPos, int pColor, INetworkEntity pEntity) {
        }

        public void onUnExecute(BlockState pState, ServerLevel pLevel, BlockPos pPos, int pColor, INetworkEntity pEntity) {
        }

        protected int getSignalForState(BlockState blockState) {
            return blockState.hasProperty((Property)BlockStateProperties.POWERED) && (Boolean)blockState.getValue((Property)BlockStateProperties.POWERED) != false ? 15 : 0;
        }

        protected BlockState setSignalForState(BlockState blockState, int strength) {
            return (BlockState)blockState.trySetValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(strength > 0));
        }

        protected abstract int getSignalStrength(Level var1, BlockPos var2);
    }
}

