/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.common;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.confluence.mod.util.AchievementUtils;
import org.jetbrains.annotations.Nullable;

public class BiomeChestBlock
extends ChestBlock {
    public static final BooleanProperty UNLOCKED = StateProperties.UNLOCKED;
    private final Predicate<ItemStack> isKey;

    public BiomeChestBlock(Predicate<ItemStack> isKey) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST).explosionResistance(18000.0f), ChestBlocks.BIOME_CHEST_ENTITY::get);
        this.isKey = isKey;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UNLOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{UNLOCKED}));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    @Nullable
    protected Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction) {
        return null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (context.getPlayer() == null || !context.getPlayer().isCreative()) {
            return (BlockState)state.setValue((Property)UNLOCKED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.isKey.test(stack) && !((Boolean)state.getValue((Property)UNLOCKED)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)UNLOCKED, (Comparable)Boolean.valueOf(true)), 3);
                serverPlayer.level().playSound(null, pos, SoundEvents.CHAIN_BREAK, SoundSource.BLOCKS);
                double posX = (double)pos.getX() + 0.5;
                double posZ = (double)pos.getZ() + 0.5;
                serverPlayer.serverLevel().sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.CHAIN.defaultBlockState()), posX, (double)pos.getY() + 0.5, posZ, 200, 0.0625, 0.0625, 0.0625, 0.15);
                if (!player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                AchievementUtils.awardAchievement(serverPlayer, "big_booty");
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return (Boolean)state.getValue((Property)UNLOCKED);
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)UNLOCKED) != false ? super.getDestroyProgress(state, player, level, pos) : 0.0f;
    }

    public static class BEntity
    extends ChestBlockEntity {
        public BEntity(BlockPos pos, BlockState blockState) {
            super(ChestBlocks.BIOME_CHEST_ENTITY.get(), pos, blockState);
        }

        public boolean canOpen(Player player) {
            return (Boolean)this.getBlockState().getValue((Property)UNLOCKED) != false && super.canOpen(player);
        }

        protected Component getDefaultName() {
            return Component.translatable((String)("container.confluence." + BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock()).getPath()));
        }

        public boolean canTakeItem(Container target, int slot, ItemStack stack) {
            return (Boolean)this.getBlockState().getValue((Property)UNLOCKED);
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return (Boolean)this.getBlockState().getValue((Property)UNLOCKED);
        }
    }
}

