/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.common;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.block.common.BaseRopeBlock;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.entity.CoinPortalEntity;
import org.confluence.mod.common.entity.projectile.bomb.BaseBombEntity;
import org.confluence.mod.common.gameevent.GoblinArmyGameEvent;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.block.PotBlocks;
import org.confluence.mod.common.init.item.ArrowItems;
import org.confluence.mod.common.init.item.ConsumableItems;
import org.confluence.mod.common.init.item.PotionItems;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.common.item.potion.AbstractPotionItem;
import org.confluence.mod.util.DateUtils;
import org.confluence.mod.util.ModUtils;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.terra_guns.common.init.TGItems;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.jetbrains.annotations.Nullable;

public class BasePotBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final VoxelShape voxelShape;
    private final float moneyRatio;
    private final float moneyHoleChance;

    public BasePotBlock(float moneyRatio, float moneyHoleChance, VoxelShape voxelShape) {
        super(BlockBehaviour.Properties.of().sound(SoundType.DECORATED_POT).instabreak().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.voxelShape = voxelShape;
        this.moneyRatio = moneyRatio;
        this.moneyHoleChance = moneyHoleChance;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        FluidState fluidstate = placeContext.getLevel().getFluidState(placeContext.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return pState;
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.BLOCKED;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.voxelShape;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return true;
    }

    public void playerDestroy(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        pPlayer.awardStat(Stats.BLOCK_MINED.get((Object)this));
        pPlayer.causeFoodExhaustion(0.005f);
        this.dropSequence(pLevel, pPos);
    }

    public void wasExploded(Level pLevel, BlockPos pPos, Explosion pExplosion) {
        this.dropSequence(pLevel, pPos);
    }

    public void onProjectileHit(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        Entity entity;
        BlockPos blockPos = pHit.getBlockPos();
        if (pLevel.destroyBlock(blockPos, true, entity = pProjectile.getOwner())) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.awardStat(Stats.BLOCK_MINED.get((Object)this));
            }
            this.dropSequence(pLevel, blockPos);
        }
    }

    private void dropSequence(Level level, BlockPos blockPos) {
        boolean flag;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 center = blockPos.getCenter();
        if (this.summonHole(serverLevel, center)) {
            return;
        }
        if (this.dropGoldKey(serverLevel, blockPos, center)) {
            return;
        }
        if (ModSecretSeeds.FOR_THE_WORTHY.match(serverLevel) && level.random.nextFloat() < 0.25f) {
            BaseBombEntity bomb = new BaseBombEntity((EntityType<? extends BaseBombEntity>)((EntityType)ModEntities.BOMB_ENTITY.get()), level);
            bomb.setPos(center);
            level.addFreshEntity((Entity)bomb);
            return;
        }
        if (this.dropPotion(serverLevel, blockPos, center)) {
            return;
        }
        if (this.dropWormhole(serverLevel, center)) {
            return;
        }
        switch (serverLevel.random.nextInt(7)) {
            case 0: {
                boolean bl = this.dropHeart(serverLevel, blockPos, center);
                break;
            }
            case 1: {
                boolean bl = this.dropTorch(serverLevel, blockPos, center);
                break;
            }
            case 2: {
                boolean bl = this.dropAmmo(serverLevel, center);
                break;
            }
            case 3: {
                boolean bl = this.dropHeal(serverLevel, blockPos, center);
                break;
            }
            case 4: {
                boolean bl = this.dropBomb(serverLevel, blockPos, center);
                break;
            }
            case 5: {
                boolean bl = this.dropRope(serverLevel, blockPos, center);
                break;
            }
            case 6: {
                boolean bl = this.dropMoney(serverLevel, blockPos, center);
                break;
            }
            default: {
                boolean bl = flag = false;
            }
        }
        if (!flag) {
            this.dropMoney(serverLevel, blockPos, center);
        }
    }

    private boolean summonHole(ServerLevel level, Vec3 center) {
        if (level.random.nextFloat() < this.moneyHoleChance) {
            CoinPortalEntity moneyHole = new CoinPortalEntity((Level)level, center);
            moneyHole.setDeltaMovement(0.0, 0.2, 0.0);
            level.addFreshEntity((Entity)moneyHole);
            return true;
        }
        return false;
    }

    private boolean dropGoldKey(ServerLevel level, BlockPos blockPos, Vec3 center) {
        Structure structure;
        if (level.random.nextFloat() < 0.0286f && (structure = (Structure)level.registryAccess().registryOrThrow(Registries.STRUCTURE).get(ModStructures.Keys.DUNGEON)) != null) {
            int chunkX = SectionPos.blockToSectionCoord((int)blockPos.getX());
            int chunkZ = SectionPos.blockToSectionCoord((int)blockPos.getZ());
            LongSet structureRefs = level.getChunk(chunkX, chunkZ, ChunkStatus.STRUCTURE_REFERENCES).getReferencesForStructure(structure);
            LongIterator longIterator = structureRefs.iterator();
            while (longIterator.hasNext()) {
                long i = (Long)longIterator.next();
                SectionPos sectionPos = SectionPos.of((ChunkPos)new ChunkPos(i), (int)level.getMinSection());
                StructureStart structureStart = level.structureManager().getStartForStructure(sectionPos, structure, (StructureAccess)level.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.STRUCTURE_STARTS));
                if (structureStart == null || !structureStart.isValid() || !structureStart.getBoundingBox().isInside((Vec3i)blockPos)) continue;
                LibUtils.createItemEntity((ItemStack)ToolItems.GOLDEN_DUNGEON_KEY.toStack(), (Vec3)center, (Level)level, (int)0);
                return true;
            }
        }
        return false;
    }

    private boolean dropPotion(ServerLevel level, BlockPos blockPos, Vec3 center) {
        float f = level.random.nextFloat();
        float f2 = LibUtils.isAtLeastExpert((Level)level, (BlockPos)blockPos) ? 0.0444f : 0.0222f;
        if (f < f2) {
            double y = center.y;
            AbstractPotionItem item = null;
            if (level.dimension() == Level.NETHER) {
                switch (level.random.nextInt(14)) {
                    case 0: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.SPELUNKER_POTION.get());
                        break;
                    }
                    case 1: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.FEATHERFALL_POTION.get());
                        break;
                    }
                    case 2: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.MANA_REGENERATION_POTION.get());
                        break;
                    }
                    case 3: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.OBSIDIAN_SKIN_POTION.get());
                        break;
                    }
                    case 4: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.MAGIC_POWER_POTION.get());
                        break;
                    }
                    case 5: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.INVISIBILITY_POTION.get());
                        break;
                    }
                    case 6: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.HUNTER_POTION.get());
                        break;
                    }
                    case 7: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.GRAVITATION_POTION.get());
                        break;
                    }
                    case 8: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.THORNS_POTION.get());
                        break;
                    }
                    case 9: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.WATER_WALKING_POTION.get());
                        break;
                    }
                    case 10: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.BATTLE_POTION.get());
                        break;
                    }
                    case 11: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.HEART_REACH_POTION.get());
                        break;
                    }
                    case 12: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.TITAN_POTION.get());
                        break;
                    }
                    default: {
                        AbstractPotionItem abstractPotionItem = item = null;
                    }
                }
                if (level.random.nextFloat() < 0.2f) {
                    // empty if block
                }
            } else if (y <= (double)OverworldUtils.getUndergroundY()) {
                item = switch (level.random.nextInt(15)) {
                    case 0 -> (AbstractPotionItem)((Object)PotionItems.SPELUNKER_POTION.get());
                    case 1 -> (AbstractPotionItem)((Object)PotionItems.FEATHERFALL_POTION.get());
                    case 2 -> (AbstractPotionItem)((Object)PotionItems.NIGHT_OWL_POTION.get());
                    case 3, 4 -> (AbstractPotionItem)((Object)PotionItems.WATER_WALKING_POTION.get());
                    case 5 -> (AbstractPotionItem)((Object)PotionItems.ARCHERY_POTION.get());
                    case 6 -> (AbstractPotionItem)((Object)PotionItems.GRAVITATION_POTION.get());
                    case 7 -> (AbstractPotionItem)((Object)PotionItems.HUNTER_POTION.get());
                    case 8 -> (AbstractPotionItem)((Object)PotionItems.INVISIBILITY_POTION.get());
                    case 9 -> (AbstractPotionItem)((Object)PotionItems.THORNS_POTION.get());
                    case 10 -> (AbstractPotionItem)((Object)PotionItems.MINING_POTION.get());
                    case 11 -> (AbstractPotionItem)((Object)PotionItems.HEART_REACH_POTION.get());
                    case 12 -> (AbstractPotionItem)((Object)PotionItems.FLIPPER_POTION.get());
                    case 13 -> (AbstractPotionItem)((Object)PotionItems.DANGERSENSE_POTION.get());
                    default -> (AbstractPotionItem)((Object)PotionItems.RECALL_POTION.get());
                };
            } else if (y <= (double)OverworldUtils.getSurfaceY()) {
                item = switch (level.random.nextInt(11)) {
                    case 0 -> (AbstractPotionItem)((Object)PotionItems.REGENERATION_POTION.get());
                    case 1 -> (AbstractPotionItem)((Object)PotionItems.SHINE_POTION.get());
                    case 2 -> (AbstractPotionItem)((Object)PotionItems.SWIFTNESS_POTION.get());
                    case 3 -> (AbstractPotionItem)((Object)PotionItems.ARCHERY_POTION.get());
                    case 4 -> (AbstractPotionItem)((Object)PotionItems.GILLS_POTION.get());
                    case 5 -> (AbstractPotionItem)((Object)PotionItems.HUNTER_POTION.get());
                    case 6 -> (AbstractPotionItem)((Object)PotionItems.MINING_POTION.get());
                    case 7 -> (AbstractPotionItem)((Object)PotionItems.DANGERSENSE_POTION.get());
                    default -> (AbstractPotionItem)((Object)PotionItems.RECALL_POTION.get());
                };
            } else if (y <= (double)OverworldUtils.getSpaceY()) {
                switch (level.random.nextInt(10)) {
                    case 0: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.IRON_SKIN_POTION.get());
                        break;
                    }
                    case 1: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.SHINE_POTION.get());
                        break;
                    }
                    case 2: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.NIGHT_OWL_POTION.get());
                        break;
                    }
                    case 3: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.SWIFTNESS_POTION.get());
                        break;
                    }
                    case 4: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.MINING_POTION.get());
                        break;
                    }
                    case 5: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.CALMING_POTION.get());
                        break;
                    }
                    case 6: {
                        AbstractPotionItem abstractPotionItem = (AbstractPotionItem)((Object)PotionItems.BUILDER_POTION.get());
                        break;
                    }
                    default: {
                        AbstractPotionItem abstractPotionItem = item = (AbstractPotionItem)((Object)PotionItems.RECALL_POTION.get());
                    }
                }
            }
            if (item != null) {
                LibUtils.createItemEntity((ItemStack)item.getDefaultInstance(), (Vec3)center, (Level)level, (int)0);
                return true;
            }
        }
        return false;
    }

    private boolean dropWormhole(ServerLevel level, Vec3 center) {
        if (level.players().size() > 1 && level.random.nextFloat() < 0.0333f) {
            LibUtils.createItemEntity((ItemStack)PotionItems.WORMHOLE_POTION.toStack(), (Vec3)center, (Level)level, (int)0);
            return true;
        }
        return false;
    }

    private boolean dropHeart(ServerLevel level, BlockPos blockPos, Vec3 center) {
        Optional optional = level.players().stream().min((a, b) -> (int)(a.distanceToSqr(center) - b.distanceToSqr(center)));
        if (optional.isPresent()) {
            Player player = (Player)optional.get();
            if (player.getHealth() < player.getMaxHealth()) {
                int amount = 1;
                if (level.random.nextBoolean()) {
                    ++amount;
                }
                if (LibUtils.isAtLeastExpert((Level)level, (BlockPos)blockPos)) {
                    if (level.random.nextBoolean()) {
                        ++amount;
                    }
                    if (level.random.nextBoolean()) {
                        ++amount;
                    }
                }
                LibUtils.createItemEntity((Item)DateUtils.getHeartItem(), (int)amount, (Vec3)center, (Level)level, (int)0);
            } else {
                if (player.getInventory().hasAnyMatching(itemStack -> itemStack.getCount() < 20 && itemStack.is(ModTags.Items.TORCH))) {
                    return this.dropTorch(level, blockPos, center);
                }
                return this.dropMoney(level, blockPos, center);
            }
        }
        return false;
    }

    private boolean dropTorch(ServerLevel level, BlockPos blockPos, Vec3 center) {
        int amount = level.random.nextInt(4, 13);
        Item item = Items.TORCH;
        LibUtils.createItemEntity((Item)item, (int)amount, (Vec3)center, (Level)level, (int)0);
        return true;
    }

    private boolean dropAmmo(ServerLevel level, Vec3 center) {
        int amount = level.random.nextInt(10, 21);
        boolean isHardmode = KillBoard.INSTANCE.getGamePhase().isHardmode();
        Item item = level.random.nextBoolean() ? (isHardmode ? (Item)ConsumableItems.GRENADE.get() : (Item)ConsumableItems.SHURIKEN.get()) : (level.dimension() == Level.NETHER ? (Item)ArrowItems.HELLFIRE_ARROW.get() : (isHardmode ? (level.random.nextBoolean() ? (Item)ArrowItems.UNHOLY_ARROW.get() : (level.random.nextBoolean() ? (Item)TGItems.SILVER_BULLET.get() : (Item)TGItems.TUNGSTEN_BULLET.get())) : Items.ARROW));
        LibUtils.createItemEntity((Item)item, (int)amount, (Vec3)center, (Level)level, (int)0);
        return true;
    }

    private boolean dropHeal(ServerLevel level, BlockPos blockPos, Vec3 center) {
        Item item = level.dimension() == Level.NETHER || KillBoard.INSTANCE.getGamePhase().isHardmode() ? (Item)PotionItems.HEALING_POTION.get() : (Item)PotionItems.LESSER_HEALING_POTION.get();
        int amount = 1;
        if (LibUtils.isAtLeastExpert((Level)level, (BlockPos)blockPos) && level.random.nextFloat() < 0.3333f) {
            ++amount;
        }
        LibUtils.createItemEntity((Item)item, (int)amount, (Vec3)center, (Level)level, (int)0);
        return true;
    }

    private boolean dropBomb(ServerLevel level, BlockPos blockPos, Vec3 center) {
        Item item;
        if (this == PotBlocks.UNDERGROUND_DESERT_POT.get()) {
            item = (Item)ConsumableItems.SCARAB_BOMB.get();
        } else if (level.dimension() == OverworldUtils.dimension()) {
            item = (Item)ConsumableItems.BOMB.get();
        } else {
            return this.dropRope(level, blockPos, center);
        }
        LibUtils.createItemEntity((Item)item, (int)level.random.nextInt(1, LibUtils.isAtLeastExpert((Level)level, (BlockPos)blockPos) ? 5 : 8), (Vec3)center, (Level)level, (int)0);
        return true;
    }

    private boolean dropRope(ServerLevel level, BlockPos blockPos, Vec3 center) {
        if (level.dimension() == Level.NETHER || KillBoard.INSTANCE.getGamePhase().isHardmode()) {
            return this.dropMoney(level, blockPos, center);
        }
        LibUtils.createItemEntity((Item)((BaseRopeBlock)((Object)ModBlocks.ROPE.get())).asItem(), (int)level.random.nextInt(5, 11), (Vec3)center, (Level)level, (int)0);
        return true;
    }

    private boolean dropMoney(ServerLevel level, BlockPos blockPos, Vec3 center) {
        if (!((Boolean)CommonConfigs.ENEMY_DROPS_MONEY.get()).booleanValue()) {
            return false;
        }
        float random = level.random.nextFloat();
        float ratio = 1.0f;
        double y = center.y;
        if (y <= (double)OverworldUtils.getUndergroundY()) {
            ratio = 1.25f;
        } else if (y <= (double)OverworldUtils.getSurfaceY()) {
            ratio = 0.75f;
        } else if (y <= (double)OverworldUtils.getSpaceY()) {
            ratio = 0.5f;
        } else if (random < 0.05f) {
            ratio = Mth.nextFloat((RandomSource)level.random, (float)1.5f, (float)2.0f);
        } else if (random < 0.0625f) {
            ratio = Mth.nextFloat((RandomSource)level.random, (float)1.4f, (float)1.8f);
        } else if (random < 0.0833f) {
            ratio = Mth.nextFloat((RandomSource)level.random, (float)1.2f, (float)1.4f);
        } else if (random < 0.125f) {
            ratio = Mth.nextFloat((RandomSource)level.random, (float)1.1f, (float)1.2f);
        } else if (random < 0.25f) {
            ratio = Mth.nextFloat((RandomSource)level.random, (float)1.05f, (float)1.1f);
        }
        if (LibUtils.isAtLeastExpert((Level)level, (BlockPos)blockPos)) {
            ratio *= 2.5f;
            random = level.random.nextFloat();
            ratio = random < 0.25f ? (ratio *= 1.25f) : (random < 0.5f ? (ratio *= 1.25f) : (ratio *= 1.75f));
        }
        int defeated = KillBoard.INSTANCE.countDefeated((EntityType)TEBossEntities.EYE_OF_CTHULHU.get(), (EntityType)TEBossEntities.EATER_OF_WORLDS.get(), (EntityType)TEBossEntities.BRAIN_OF_CTHULHU.get(), (EntityType)TEBossEntities.QUEEN_BEE.get(), (EntityType)TEBossEntities.SKELETRON.get(), (EntityType)TEBossEntities.THE_TWINS.get(), (EntityType)TEBossEntities.PLANTERA.get()) + KillBoard.INSTANCE.countDefeated(GoblinArmyGameEvent.KEY);
        for (int i = 0; i < defeated; ++i) {
            ratio *= 1.1f;
        }
        int amount = (int)Math.ceil((float)level.random.nextInt(80, 358) * (ratio *= this.moneyRatio));
        ModUtils.dropMoney(amount, center.x, y, center.z, (Level)level);
        return true;
    }
}

