/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.common;

import com.mojang.serialization.MapCodec;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;

public class AetheriumCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<AetheriumCauldronBlock> CODEC = AetheriumCauldronBlock.simpleCodec(AetheriumCauldronBlock::new);
    public static final CauldronInteraction.InteractionMap DO_NOTHING = (CauldronInteraction.InteractionMap)Util.make((Object)CauldronInteraction.newInteractionMap((String)"confluence_do_nothing"), map -> {});
    public static final CauldronInteraction FILL_AETHERIUM = (blockState, level, blockPos, player, hand, itemStack) -> {
        if (!level.isClientSide) {
            ItemStack filledStack;
            boolean bottomless = itemStack.is(ModTags.Items.BOTTOMLESS);
            ItemStack itemStack2 = filledStack = bottomless ? itemStack : NatureBlocks.AETHERIUM_BLOCK.toStack();
            if (!bottomless) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            player.awardStat(Stats.FILL_CAULDRON);
            player.awardStat(Stats.ITEM_USED.get((Object)filledStack.getItem()));
            level.setBlockAndUpdate(blockPos, ((AetheriumCauldronBlock)((Object)((Object)ModBlocks.AETHERIUM_CAULDRON.get()))).defaultBlockState());
            level.playSound(null, blockPos, SoundEvents.AMETHYST_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, blockPos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    };

    public AetheriumCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties, DO_NOTHING);
    }

    protected MapCodec<AetheriumCauldronBlock> codec() {
        return CODEC;
    }

    protected double getContentHeight(BlockState state) {
        return 0.9375;
    }

    public boolean isFull(BlockState state) {
        return true;
    }

    public boolean isEntityInsideContent(BlockState state, BlockPos pos, Entity entity) {
        return super.isEntityInsideContent(state, pos, entity);
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return 3;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            ItemStack filledStack = NatureBlocks.AETHERIUM_BLOCK.toStack();
            if (player.hasInfiniteMaterials()) {
                if (!player.getInventory().contains(filledStack)) {
                    player.getInventory().add(filledStack);
                }
            } else if (!player.getInventory().add(filledStack)) {
                player.drop(filledStack, false);
            }
            player.awardStat(Stats.USE_CAULDRON);
            level.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
            level.playSound(null, pos, SoundEvents.AMETHYST_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

