/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.attachment;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.confluence.mod.api.event.AfterFlushArmorSetBonusEvent;
import org.confluence.mod.common.init.ModAttachmentTypes;
import org.confluence.mod.common.init.armor.ArmorSetBonusData;
import org.confluence.mod.common.init.armor.ArmorSetBonusKey;
import org.confluence.mod.common.init.armor.ModArmorBonus;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.terra_curio.common.attachment.PrimitiveValueHolder;
import org.confluence.terra_curio.common.component.PrimitiveValueComponent;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.jetbrains.annotations.NotNull;

public class PlayerSpecialData
extends PrimitiveValueHolder {
    @NotNull
    private ArmorSetBonusKey armorSetBonusKey = ArmorSetBonusKey.NONE;
    private ItemStack currentQuestedFish;
    private ITradeLock currentQuestedFishCondition;
    private boolean couldHurtCritters;
    private boolean couldDamageEnvironment;
    private boolean fallenSoulCoreActive = false;

    public void setToDefaultValue() {
        super.setToDefaultValue();
        this.armorSetBonusKey = ArmorSetBonusKey.NONE;
        this.currentQuestedFish = ItemStack.EMPTY;
        this.currentQuestedFishCondition = ITradeLock.alwaysTrue();
        this.couldHurtCritters = true;
        this.couldDamageEnvironment = true;
        this.fallenSoulCoreActive = false;
    }

    public ArmorSetBonusKey getArmorSetBonusKey() {
        return this.armorSetBonusKey;
    }

    public void setCurrentQuestedFish(ItemStack cost, ITradeLock lock) {
        this.currentQuestedFish = cost;
        this.currentQuestedFishCondition = lock;
    }

    public void removeCurrentQuestedFish() {
        this.setCurrentQuestedFish(ItemStack.EMPTY, ITradeLock.alwaysTrue());
    }

    public ItemStack getCurrentQuestedFish(Player player) {
        if (this.currentQuestedFishCondition.canTrade(player, ITradeHolder.dummy((Player)player), 0)) {
            return this.currentQuestedFish;
        }
        return ItemStack.EMPTY;
    }

    public void setCouldHurtCritters(boolean couldHurtCritters) {
        this.couldHurtCritters = couldHurtCritters;
    }

    public boolean isCouldHurtCritters() {
        return this.couldHurtCritters;
    }

    public void setCouldDamageEnvironment(boolean couldDamageEnvironment) {
        this.couldDamageEnvironment = couldDamageEnvironment;
    }

    public boolean isCouldDamageEnvironment() {
        return this.couldDamageEnvironment;
    }

    public boolean isFallenSoulCoreActive() {
        return this.fallenSoulCoreActive;
    }

    public void setFallenSoulCoreActive(boolean active) {
        this.fallenSoulCoreActive = active;
    }

    public void flushArmorSetBonus(Player player) {
        ArmorSetBonusKey lastKey;
        ItemStack feet;
        ItemStack legs;
        ItemStack chest;
        Inventory inventory = player.getInventory();
        ItemStack head = inventory.getArmor(EquipmentSlot.HEAD.getIndex());
        ArmorSetBonusKey key = ArmorSetBonusKey.of(head, chest = inventory.getArmor(EquipmentSlot.CHEST.getIndex()), legs = inventory.getArmor(EquipmentSlot.LEGS.getIndex()), feet = inventory.getArmor(EquipmentSlot.FEET.getIndex()));
        if (this.armorSetBonusKey.equals(key) && (lastKey = ArmorSetBonusKey.of(player.getLastArmorItem(EquipmentSlot.HEAD), player.getLastArmorItem(EquipmentSlot.CHEST), player.getLastArmorItem(EquipmentSlot.LEGS), player.getLastArmorItem(EquipmentSlot.FEET))).equals(key)) {
            return;
        }
        AttributeMap attributes = player.getAttributes();
        for (Map.Entry entry : ((ImmutableListMultimap)this.getValue(TCItems.ATTRIBUTES)).asMap().entrySet()) {
            AttributeInstance attributeinstance = attributes.getInstance((Holder)entry.getKey());
            if (attributeinstance == null) continue;
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                attributeinstance.removeModifier(modifier);
            }
        }
        this.setToDefaultValue();
        ArmorSetBonusData data = ModArmorBonus.getArmorSetBonusData(player, key);
        if (data == null) {
            this.armorSetBonusKey = ArmorSetBonusKey.NONE;
        } else {
            this.armorSetBonusKey = key;
            this.compute(data.bonus());
        }
        this.flushArmor(head);
        this.flushArmor(chest);
        this.flushArmor(legs);
        this.flushArmor(feet);
        for (Map.Entry entry : ((ImmutableListMultimap)this.getValue(TCItems.ATTRIBUTES)).asMap().entrySet()) {
            AttributeInstance attributeinstance = attributes.getInstance((Holder)entry.getKey());
            if (attributeinstance == null) continue;
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                attributeinstance.removeModifier(modifier);
                attributeinstance.addTransientModifier(modifier);
            }
        }
        NeoForge.EVENT_BUS.post((Event)new AfterFlushArmorSetBonusEvent(player, this));
    }

    private void flushArmor(ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        PrimitiveValueComponent component = ModArmorBonus.getArmorStackBonus(stack);
        if (component != null) {
            this.compute(component);
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        CompoundTag tag = super.serializeNBT(provider);
        ArmorSetBonusKey.CODEC.encodeStart((DynamicOps)ops, (Object)this.armorSetBonusKey).ifSuccess(nbt -> tag.put("ArmorBonusKey", nbt));
        tag.put("CurrentQuestedFish", ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)ops, (Object)this.currentQuestedFish).result().orElseGet(CompoundTag::new));
        tag.put("CurrentQuestedFishCondition", ITradeLock.TYPED_CODEC.encodeStart((DynamicOps)ops, (Object)this.currentQuestedFishCondition).result().orElseGet(CompoundTag::new));
        tag.putBoolean("CouldHurtCritters", this.couldHurtCritters);
        tag.putBoolean("FallenSoulCoreActive", this.fallenSoulCoreActive);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        super.deserializeNBT(provider, nbt);
        if (nbt.contains("ArmorBonusKey")) {
            this.armorSetBonusKey = ArmorSetBonusKey.CODEC.parse((DynamicOps)ops, (Object)nbt.get("ArmorBonusKey")).result().orElse(ArmorSetBonusKey.NONE);
        }
        this.currentQuestedFish = ItemStack.OPTIONAL_CODEC.parse((DynamicOps)ops, (Object)nbt.get("CurrentQuestedFish")).result().orElse(ItemStack.EMPTY);
        this.currentQuestedFishCondition = ITradeLock.TYPED_CODEC.parse((DynamicOps)ops, (Object)nbt.get("CurrentQuestedFishCondition")).result().orElse(ITradeLock.alwaysTrue());
        this.couldHurtCritters = nbt.getBoolean("CouldHurtCritters");
        this.fallenSoulCoreActive = nbt.getBoolean("FallenSoulCoreActive");
    }

    public static PlayerSpecialData of(Player player) {
        return (PlayerSpecialData)((Object)player.getData(ModAttachmentTypes.SPECIAL_DATA));
    }

    public static void resetSomeData(Player player) {
        PlayerSpecialData data = PlayerSpecialData.of(player);
        if (!data.isCouldHurtCritters() || !data.isCouldDamageEnvironment()) {
            data.setCouldHurtCritters(true);
            data.setCouldDamageEnvironment(true);
            for (ItemStack stack : Iterables.concat((Iterable)player.getInventory().offhand, (Iterable)player.getInventory().items)) {
                boolean c;
                boolean a = data.isCouldHurtCritters();
                boolean b = data.isCouldDamageEnvironment();
                if (!a && !b) break;
                Item item = stack.getItem();
                boolean bl = c = item == ToolItems.GUIDE_TO_PEACEFUL_COEXISTENCE.get();
                if (a && (c || item == ToolItems.GUIDE_TO_CRITTER_COMPANIONSHIP.get())) {
                    data.setCouldHurtCritters(false);
                }
                if (!b || !c && item != ToolItems.GUIDE_TO_ENVIRONMENTAL_PRESERVATION.get()) continue;
                data.setCouldDamageEnvironment(false);
            }
        }
    }
}

