/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.attachment;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.confluence.lib.common.PlayerContainer;
import org.confluence.mod.common.block.functional.PiggyBankBlock;
import org.confluence.mod.common.init.ModAttachmentTypes;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.item.common.CoinItem;
import org.confluence.mod.network.s2c.PiggyBankTotalMoneyPacket;
import org.confluence.mod.util.Coins;
import org.confluence.mod.util.PlayerUtils;
import org.jetbrains.annotations.ApiStatus;

public class PlayerPiggyBankContainer
extends PlayerContainer<PiggyBankBlock.BEntity> {
    private long totalMoney;
    private Player owner;

    public PlayerPiggyBankContainer() {
        super(6);
        this.addListener(container -> {
            if (this.owner == null || this.owner.isLocalPlayer()) {
                return;
            }
            long res = 0L;
            for (int i = 0; i < container.getContainerSize(); ++i) {
                int index;
                ItemStack stack = container.getItem(i);
                if (stack.isEmpty() || !stack.is(ModTags.Items.COINS) || (index = PlayerUtils.COIN_2_INDEX.applyAsInt(stack.getItem())) == -1) continue;
                res += (long)((double)stack.getCount() * Math.pow(100.0, 3 - index));
            }
            if (this.totalMoney != res) {
                this.totalMoney = res;
                Player patt0$temp = this.owner;
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    PiggyBankTotalMoneyPacket.sendToClient(player, this, false);
                }
            }
        });
    }

    @ApiStatus.Internal
    public void setTotalMoney(long totalMoney) {
        this.totalMoney = totalMoney;
    }

    public long getTotalMoney() {
        return this.totalMoney;
    }

    public long tryCostMoney(long cost) {
        if (cost <= 0L) {
            return 0L;
        }
        if (this.totalMoney <= 0L) {
            return cost;
        }
        long res = this.totalMoney - cost;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty() || !stack.is(ModTags.Items.COINS)) continue;
            this.setItemNoUpdate(i, ItemStack.EMPTY);
        }
        if (res > 0L) {
            Coins coins = PlayerUtils.decodeCoin(res);
            for (Object2IntMap.Entry entry : coins.copper2PlatinumEntries()) {
                int coin = entry.getIntValue();
                if (coin <= 0) continue;
                CoinItem coinItem = (CoinItem)((Object)entry.getKey());
                while (coin > 100) {
                    this.addItem(new ItemStack((ItemLike)coinItem, 100));
                    coin -= 100;
                }
                this.addItem(new ItemStack((ItemLike)coinItem, coin));
            }
        }
        this.setChanged();
        return res < 0L ? -res : 0L;
    }

    @ApiStatus.Internal
    public void setOwner(Player player) {
        this.owner = player;
    }

    public static PlayerPiggyBankContainer of(Player player) {
        PlayerPiggyBankContainer data = (PlayerPiggyBankContainer)((Object)player.getData(ModAttachmentTypes.PIGGY_BANK));
        data.setOwner(player);
        return data;
    }
}

