/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.Tags;
import org.confluence.mod.Confluence;

public final class CommonConfigs {
    public static ModConfigSpec.BooleanValue ENEMY_DROPS_MONEY;
    public static ModConfigSpec.BooleanValue AUTO_STACK_GELS_COLOR;
    public static ModConfigSpec.BooleanValue RETURN_POTION_GLASS_BOTTLE;
    public static ModConfigSpec.BooleanValue RIGHT_CLICK_RIDE_MINECART;
    public static ModConfigSpec.IntValue ANNOUNCEMENT_BOX_DISTANCE;
    public static ModConfigSpec.BooleanValue ALERT_PLAYER_IN_DUNGEON;
    public static ModConfigSpec.BooleanValue STAR_PHASE;
    private static ModConfigSpec.ConfigValue<List<? extends String>> AMMO_SLOTS_BLACKLIST;
    public static ModConfigSpec.BooleanValue TERRA_STYLE_EXPLOSION;
    public static ModConfigSpec.BooleanValue TERRA_STYLE_FIRE_DAMAGE;
    public static ModConfigSpec.BooleanValue NPC_INVULNERABLE_TO_PLAYER;
    public static ModConfigSpec.BooleanValue ALLOWS_VANILLA_ENTITIES_TO_PERFORM_STAGE_ATTRIBUTES;
    public static ModConfigSpec.BooleanValue FLETCHING_MENU;
    public static ModConfigSpec.BooleanValue SHIMMER_DECOMPOSE;
    public static ModConfigSpec.BooleanValue ALTAR_TIPS;
    public static ModConfigSpec.BooleanValue DO_FALLING_STAR_SPAWNING;
    public static ModConfigSpec.IntValue FALLING_STAR_INTERVAL;
    public static ModConfigSpec.BooleanValue DO_NPC_SPAWNING;
    public static ModConfigSpec.IntValue NPC_SPAWN_INTERVAL;
    public static ModConfigSpec.BooleanValue BROADCAST_NPC_MSG;
    public static ModConfigSpec.BooleanValue EYE_OF_CTHULHU_NATURE_SPAWNING;
    public static ModConfigSpec.BooleanValue DEERCLOPS_NATURE_SPAWNING;
    public static ModConfigSpec.BooleanValue DO_METEORITE_SPAWNING;
    public static ModConfigSpec.BooleanValue PLAYER_DROPS_MONEY;
    public static ModConfigSpec.BooleanValue SHOW_MONEY_DROPS;
    public static ModConfigSpec.BooleanValue DROPS_TOMBSTONE;
    public static ModConfigSpec.IntValue DEFAULT_RESPAWN_TIME_MIN;
    public static ModConfigSpec.IntValue DEFAULT_RESPAWN_TIME_MAX;
    public static ModConfigSpec.IntValue BOSS_RESPAWN_TIME_MIN;
    public static ModConfigSpec.IntValue BOSS_RESPAWN_TIME_MAX;
    public static ModConfigSpec.BooleanValue WRAPPED_CRIMSON_HEART;
    public static ModConfigSpec.BooleanValue INSTANTLY_HARDMODE_CONVERSION;
    public static ModConfigSpec.BooleanValue CONVERT_ARS_NOUVEAU_MANA;
    public static ModConfigSpec.BooleanValue CONVERT_IRONS_SPELL_MANA;
    public static ModConfigSpec.BooleanValue FTB_CHUNKS_WORMHOLE_POTION;
    public static ModConfigSpec.BooleanValue WAYSTONES_PYLON_NON_COST;
    public static ModConfigSpec.IntValue SLIME_RAIN_EVENT_MAX_ENEMIES_BASE;
    public static ModConfigSpec.IntValue SLIME_RAIN_EVENT_MAX_ENEMIES_PER_PLAYER;
    public static ModConfigSpec.DoubleValue SLIME_RAIN_EVENT_SPAWN_INTERVAL_FACTOR;
    public static ModConfigSpec.IntValue SLIME_RAIN_EVENT_SPAWN_GROUP_SIZE;
    public static ModConfigSpec.IntValue SLIME_RAIN_EVENT_KING_SLIME_SPAWN_REQUIRED_KILL_COUNT;
    public static ModConfigSpec.IntValue SLIME_RAIN_EVENT_REQUIRED_PLAYER_MAX_HEALTH;
    public static ModConfigSpec.IntValue SLIME_RAIN_EVENT_REQUIRED_PLAYER_ARMOR;
    public static ModConfigSpec.IntValue SLIME_RAIN_EVENT_FREQUENCY;
    public static ModConfigSpec.IntValue BLOOD_MOON_EVENT_MAX_ENEMIES_BASE;
    public static ModConfigSpec.IntValue BLOOD_MOON_EVENT_MAX_ENEMIES_PER_PLAYER;
    public static ModConfigSpec.DoubleValue BLOOD_MOON_EVENT_SPAWN_ENEMIES_INTERVAL_FACTOR;
    public static ModConfigSpec.IntValue BLOOD_MOON_EVENT_REQUIRED_PLAYER_MAX_HEALTH;
    public static ModConfigSpec.IntValue BLOOD_MOON_EVENT_REQUIRED_PLAYER_ARMOR;
    public static ModConfigSpec.IntValue BLOOD_MOON_EVENT_INVERT_CHANCE;
    public static ModConfigSpec.IntValue GOBLIN_ARMY_EVENT_MAX_ENEMIES_BASE;
    public static ModConfigSpec.IntValue GOBLIN_ARMY_EVENT_MAX_ENEMIES_PER_PLAYER;
    public static ModConfigSpec.DoubleValue GOBLIN_ARMY_EVENT_SPAWN_ENEMIES_INTERVAL_FACTOR;
    public static ModConfigSpec.IntValue GOBLIN_ARMY_EVENT_REQUIRED_PLAYER_MAX_HEALTH;
    public static ModConfigSpec.IntValue GOBLIN_ARMY_EVENT_REQUIRED_PLAYER_ARMOR;
    public static ModConfigSpec.IntValue GOBLIN_ARMY_EVENT_INVERT_CHANCE;
    public static ModConfigSpec.IntValue GOBLIN_ARMY_EVENT_DEFEATED_INVERT_CHANCE;
    public static ModConfigSpec.IntValue GOBLIN_ARMY_EVENT_HARDMODE_INVERT_CHANCE;
    public static ModConfigSpec.IntValue GOBLIN_ARMY_EVENT_HARDMODE_DEFEATED_INVERT_CHANCE;
    public static ModConfigSpec.IntValue GOBLIN_ARMY_EVENT_REQUIRED_KILL_COUNT_BASE;
    public static ModConfigSpec.IntValue GOBLIN_ARMY_EVENT_REQUIRED_KILL_COUNT_PER_PLAYER;
    public static ModConfigSpec.DoubleValue METEOR_SHOWER_EVENT_FALLING_STAR_SPAWN_SPEED_MULTIPLIER;
    public static ModConfigSpec.IntValue METEOR_SHOWER_EVENT_FREQUENCY;
    public static ModConfigSpec.IntValue METEOR_SHOWER_EVENT_CELEBRATIONMK10_FREQUENCY;
    public static ModConfigSpec.IntValue METEOR_SHOWER_EVENT_MAX_ENCHANTED_NIGHTCRAWLERS_BASE;
    public static ModConfigSpec.IntValue METEOR_SHOWER_EVENT_MAX_ENCHANTED_NIGHTCRAWLERS_PER_PLAYER;
    public static ModConfigSpec.IntValue METEOR_SHOWER_EVENT_SPAWN_ENCHANTED_NIGHTCRAWLERS_INTERVAL_FACTOR;
    public static Set<ResourceKey<Item>> ammoSlotsItemBlackList;
    public static Set<TagKey<Item>> ammoSlotsTagBlackList;

    public static void onLoad() {
        HashSet<ResourceKey<Item>> a = new HashSet<ResourceKey<Item>>();
        HashSet<TagKey<Item>> b = new HashSet<TagKey<Item>>();
        for (String s : (List)AMMO_SLOTS_BLACKLIST.get()) {
            if (s.startsWith("#")) {
                b.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)s.substring(1))));
                continue;
            }
            a.add((ResourceKey<Item>)ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)s)));
        }
        ammoSlotsItemBlackList = a;
        ammoSlotsTagBlackList = b;
    }

    public static void register(ModContainer container) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Gameplay");
        ENEMY_DROPS_MONEY = builder.define("enemyDropsMoney", true);
        AUTO_STACK_GELS_COLOR = builder.define("autoStackGelsColor", true);
        RETURN_POTION_GLASS_BOTTLE = builder.define("returnPotionGlassBottle", false);
        RIGHT_CLICK_RIDE_MINECART = builder.define("rightClickRideMinecart", true);
        ANNOUNCEMENT_BOX_DISTANCE = builder.defineInRange("announcementBoxDistance", 128, 0, Integer.MAX_VALUE);
        ALERT_PLAYER_IN_DUNGEON = builder.define("alertPlayerDungeon", false);
        STAR_PHASE = builder.define("starPhase", false);
        AMMO_SLOTS_BLACKLIST = builder.defineListAllowEmpty("ammoSlotsBlacklist", () -> List.of("confluence:falling_star", "#c:seeds"), () -> "[#]namespace:path", o -> {
            if (o instanceof String) {
                String s = (String)o;
                if (s.startsWith("#")) {
                    return ResourceLocation.tryParse((String)s.substring(1)) != null;
                }
                return ResourceLocation.tryParse((String)s) != null;
            }
            return false;
        });
        TERRA_STYLE_EXPLOSION = builder.define("terraStyleExplosion", true);
        TERRA_STYLE_FIRE_DAMAGE = builder.define("terraStyleFireDamage", true);
        NPC_INVULNERABLE_TO_PLAYER = builder.define("npcInvulnerableToPlayer", true);
        ALLOWS_VANILLA_ENTITIES_TO_PERFORM_STAGE_ATTRIBUTES = builder.define("allowsVanillaEntitiesToPerformStageAttributes", false);
        builder.pop();
        builder.push("Recipe");
        FLETCHING_MENU = builder.define("fletchingMenu", true);
        SHIMMER_DECOMPOSE = builder.define("shimmerDecompose", true);
        ALTAR_TIPS = builder.define("altarTips", true);
        builder.pop();
        builder.push("Spawning");
        builder.push("Falling Star");
        DO_FALLING_STAR_SPAWNING = builder.define("doFallingStarSpawning", true);
        FALLING_STAR_INTERVAL = builder.defineInRange("fallingStarInterval", 2400, 20, 20000);
        builder.pop();
        builder.push("NPC");
        DO_NPC_SPAWNING = builder.define("doNPCSpawning", true);
        NPC_SPAWN_INTERVAL = builder.defineInRange("npcSpawnInterval", 2400, 20, 20000);
        BROADCAST_NPC_MSG = builder.define("broadcastNpcMsg", true);
        builder.pop();
        builder.push("Boss");
        EYE_OF_CTHULHU_NATURE_SPAWNING = builder.define("eyeOfCthulhuNatureSpawning", true);
        DEERCLOPS_NATURE_SPAWNING = builder.define("deerclopsNatureSpawning", true);
        builder.pop();
        DO_METEORITE_SPAWNING = builder.define("doMeteoriteSpawning", true);
        builder.pop();
        builder.push("PlayerDeath");
        PLAYER_DROPS_MONEY = builder.define("playerDropsMoney", true);
        SHOW_MONEY_DROPS = builder.define("showMoneyDrops", true);
        DROPS_TOMBSTONE = builder.define("dropsTombstone", true);
        DEFAULT_RESPAWN_TIME_MIN = builder.defineInRange("defaultRespawnTimeMin", 3, 0, Integer.MAX_VALUE);
        DEFAULT_RESPAWN_TIME_MAX = builder.defineInRange("defaultRespawnTimeMax", 8, 0, Integer.MAX_VALUE);
        BOSS_RESPAWN_TIME_MIN = builder.defineInRange("bossRespawnTimeMin", 9, 0, Integer.MAX_VALUE);
        BOSS_RESPAWN_TIME_MAX = builder.defineInRange("bossRespawnTimeMax", 18, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("WorldGeneration");
        WRAPPED_CRIMSON_HEART = builder.define("wrappedCrimsonHeart", false);
        INSTANTLY_HARDMODE_CONVERSION = builder.define("instantlyHardmodeConversion", false);
        builder.pop();
        builder.push("Compatibility");
        builder.push("ArsNouveau");
        CONVERT_ARS_NOUVEAU_MANA = builder.define("convertArsNouveauMana", false);
        builder.pop();
        builder.push("IronsSpell");
        CONVERT_IRONS_SPELL_MANA = builder.define("convertIronsSpellMana", false);
        builder.pop();
        builder.push("FTB");
        FTB_CHUNKS_WORMHOLE_POTION = builder.define("ftbChunksWormholePotion", true);
        builder.pop();
        builder.push("Waystones");
        WAYSTONES_PYLON_NON_COST = builder.define("waystonesPylonNonCost", true);
        builder.pop();
        builder.pop();
        builder.push("GameEvent");
        builder.push("SlimeRain");
        SLIME_RAIN_EVENT_MAX_ENEMIES_BASE = builder.defineInRange("slimeRainEventMaxEnemiesBase", 25, 1, 1024);
        SLIME_RAIN_EVENT_MAX_ENEMIES_PER_PLAYER = builder.defineInRange("slimeRainEventPerPlayer", 25, 1, 1024);
        SLIME_RAIN_EVENT_SPAWN_INTERVAL_FACTOR = builder.defineInRange("slimeRainEventSpawnIntervalFactor", 1.0, 0.1, 10.0);
        SLIME_RAIN_EVENT_SPAWN_GROUP_SIZE = builder.defineInRange("slimeRainEventSpawnGroupSize", 4, 1, 1024);
        SLIME_RAIN_EVENT_KING_SLIME_SPAWN_REQUIRED_KILL_COUNT = builder.defineInRange("slimeRainEventKingSlimeSpawnRequiredKillCount", 150, 1, 1024);
        SLIME_RAIN_EVENT_REQUIRED_PLAYER_MAX_HEALTH = builder.defineInRange("slimeRainEventRequiredPlayerMaxHealth", 28, 0, 1024);
        SLIME_RAIN_EVENT_REQUIRED_PLAYER_ARMOR = builder.defineInRange("slimeRainEventRequiredPlayerArmor", 14, 0, 1024);
        SLIME_RAIN_EVENT_FREQUENCY = builder.defineInRange("slimeRainEventFrequency", 675000, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("BloodMoon");
        BLOOD_MOON_EVENT_MAX_ENEMIES_BASE = builder.defineInRange("bloodMoonEventMaxEnemiesBase", 30, 1, 1024);
        BLOOD_MOON_EVENT_MAX_ENEMIES_PER_PLAYER = builder.defineInRange("bloodMoonEventMaxEnemiesPerPlayer", 30, 1, 1024);
        BLOOD_MOON_EVENT_SPAWN_ENEMIES_INTERVAL_FACTOR = builder.defineInRange("bloodMoonEventSpawnEnemiesIntervalFactor", 1.5, 0.1, 10.0);
        BLOOD_MOON_EVENT_REQUIRED_PLAYER_MAX_HEALTH = builder.defineInRange("bloodMoonEventRequiredPlayerMaxHealth", 24, 0, 1024);
        BLOOD_MOON_EVENT_REQUIRED_PLAYER_ARMOR = builder.defineInRange("bloodMoonEventRequiredPlayerArmor", 16, 0, 1024);
        BLOOD_MOON_EVENT_INVERT_CHANCE = builder.defineInRange("bloodMoonEventInvertChance", 14, 1, 1024);
        builder.pop();
        builder.push("GoblinArmy");
        GOBLIN_ARMY_EVENT_MAX_ENEMIES_BASE = builder.defineInRange("goblinArmyEventMaxEnemiesBase", 30, 1, 1024);
        GOBLIN_ARMY_EVENT_MAX_ENEMIES_PER_PLAYER = builder.defineInRange("goblinArmyEventMaxEnemiesPerPlayer", 30, 1, 1024);
        GOBLIN_ARMY_EVENT_SPAWN_ENEMIES_INTERVAL_FACTOR = builder.defineInRange("goblinArmyEventSpawnEnemiesIntervalFactor", 1.5, 0.1, 10.0);
        GOBLIN_ARMY_EVENT_REQUIRED_PLAYER_MAX_HEALTH = builder.defineInRange("goblinArmyEventRequiredPlayerMaxHealth", 24, 0, 1024);
        GOBLIN_ARMY_EVENT_REQUIRED_PLAYER_ARMOR = builder.defineInRange("goblinArmyEventRequiredPlayerArmor", 16, 0, 1024);
        GOBLIN_ARMY_EVENT_INVERT_CHANCE = builder.defineInRange("goblinArmyEventInvertChance", 3, 1, 1024);
        GOBLIN_ARMY_EVENT_DEFEATED_INVERT_CHANCE = builder.defineInRange("goblinArmyEventInvertChance", 3, 1, 1024);
        GOBLIN_ARMY_EVENT_HARDMODE_INVERT_CHANCE = builder.defineInRange("goblinArmyEventInvertChance", 30, 1, 1024);
        GOBLIN_ARMY_EVENT_HARDMODE_DEFEATED_INVERT_CHANCE = builder.defineInRange("goblinArmyEventInvertChance", 60, 1, 1024);
        GOBLIN_ARMY_EVENT_REQUIRED_KILL_COUNT_BASE = builder.defineInRange("goblinArmyEventRequiredKillCountBase", 80, 1, 1024);
        GOBLIN_ARMY_EVENT_REQUIRED_KILL_COUNT_PER_PLAYER = builder.defineInRange("goblinArmyEventRequiredKillCountPerPlayer", 40, 1, 1024);
        builder.pop();
        builder.push("MeteorShower");
        METEOR_SHOWER_EVENT_FALLING_STAR_SPAWN_SPEED_MULTIPLIER = builder.defineInRange("meteorShowerEventFallingStarSpawnSpeedMultiplier", 3.0, 2.0, 4.0);
        METEOR_SHOWER_EVENT_FREQUENCY = builder.defineInRange("meteorShowerEventFrequency", 10, 1, Integer.MAX_VALUE);
        METEOR_SHOWER_EVENT_CELEBRATIONMK10_FREQUENCY = builder.defineInRange("meteorShowerEventCelebrationMK10Frequency", 5, 1, Integer.MAX_VALUE);
        METEOR_SHOWER_EVENT_MAX_ENCHANTED_NIGHTCRAWLERS_BASE = builder.defineInRange("meteorShowerEventMaxEnchantedNightcrawlersBase", 1, 1, 1024);
        METEOR_SHOWER_EVENT_MAX_ENCHANTED_NIGHTCRAWLERS_PER_PLAYER = builder.defineInRange("meteorShowerEventMaxEnchantedNightcrawlersPerPlayer", 2, 1, 1024);
        METEOR_SHOWER_EVENT_SPAWN_ENCHANTED_NIGHTCRAWLERS_INTERVAL_FACTOR = builder.defineInRange("meteorShowerEventSpawnEnchantedNightcrawlersIntervalFactor", 20, 1, 1024);
        builder.pop();
        builder.pop();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build());
    }

    static {
        ammoSlotsItemBlackList = Set.of(Confluence.asResourceKey(Registries.ITEM, "falling_star"));
        ammoSlotsTagBlackList = Set.of(Tags.Items.SEEDS);
    }
}

