/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.tooltip;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.item.tooltipcomponent.AltImageComponent;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
public class AltImageTooltip
implements ClientTooltipComponent {
    private static final Vector3f DIFFUSE_LIGHT_0 = new Vector3f(0.2f, 1.0f, -0.7f).normalize();
    private static final Vector3f DIFFUSE_LIGHT_1 = new Vector3f(-0.2f, 1.0f, 0.7f).normalize();
    private final ItemStack stack;

    public AltImageTooltip(ItemStack stack) {
        this.stack = stack;
    }

    public AltImageTooltip(AltImageComponent component) {
        this(component.stack());
    }

    public int getHeight() {
        return 32;
    }

    public int getWidth(Font font) {
        return 32;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.getInstance();
        PoseStack pose = guiGraphics.pose();
        BakedModel bakedModel = minecraft.getItemRenderer().getModel(this.stack, (Level)minecraft.level, (LivingEntity)minecraft.player, 20251001);
        pose.pushPose();
        pose.translate((float)(x + 16), (float)(y + 40), 150.0f);
        try {
            boolean flag;
            pose.scale(-32.0f, -32.0f, 32.0f);
            boolean bl = flag = !bakedModel.usesBlockLight();
            if (flag) {
                Matrix4f matrix4f = new Matrix4f().rotationY(-0.3926991f).rotateX(-2.3561945f);
                GlStateManager.setupLevelDiffuseLighting((Vector3f)DIFFUSE_LIGHT_1, (Vector3f)DIFFUSE_LIGHT_0, (Matrix4f)matrix4f);
            }
            minecraft.getItemRenderer().render(this.stack, ItemDisplayContext.HEAD, false, pose, (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
            guiGraphics.flush();
            if (flag) {
                Lighting.setupFor3DItems();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
            crashreportcategory.setDetail("Item Type", () -> String.valueOf(this.stack.getItem()));
            crashreportcategory.setDetail("Item Components", () -> String.valueOf(this.stack.getComponents()));
            crashreportcategory.setDetail("Item Foil", () -> String.valueOf(this.stack.hasFoil()));
            throw new ReportedException(crashreport);
        }
        pose.popPose();
    }
}

