/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.handler.LucyTheAxeHandler;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class LucyTheAxeDialogRenderer {
    private static final ResourceLocation background = Confluence.asResource("dialog_background");
    private static final ResourceLocation tail = Confluence.asResource("dialog_tail");
    private static final Quaternionf quaternion = new Quaternionf();
    private static final Matrix4f matrix = new Matrix4f();
    public static final int COLOR = -5636096;
    public static Component dialog;
    private static Consumer<GuiGraphics> delayed;

    public static void renderInGui(Minecraft minecraft, PoseStack poseStack) {
        int textW = minecraft.font.width((FormattedText)dialog);
        float itemX = poseStack.last().pose().m30();
        float itemY = poseStack.last().pose().m31();
        float x = itemX - (float)textW * 0.5f;
        float y = itemY - 48.0f;
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        FormattedCharSequence text = dialog.getVisualOrderText();
        delayed = graphics -> {
            int y1 = (int)y - 5;
            int n = (int)x - 4;
            Objects.requireNonNull(minecraft.font);
            graphics.blitSprite(background, n, y1, textW + 8, 9 + 9);
            graphics.blitSprite(tail, (int)itemX + 8, y1 + 17, 8, 8);
            minecraft.font.renderText(text, x, y, -5636096, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        };
    }

    public static void reset() {
        dialog = null;
        delayed = null;
    }

    public static void renderDelayed(GuiGraphics graphics) {
        if (delayed != null) {
            delayed.accept(graphics);
            delayed = null;
        }
    }

    public static void renderInWorld(Minecraft minecraft, PoseStack poseStack) {
        Queue<LucyTheAxeHandler.Stack> stacks = LucyTheAxeHandler.getStacks();
        if (stacks.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        Camera camera = minecraft.gameRenderer.getMainCamera();
        float x = (float)camera.getPosition().x;
        float y = (float)camera.getPosition().y;
        float z = (float)camera.getPosition().z;
        Quaternionf rotation = camera.rotation();
        quaternion.set(0.0f, rotation.y, 0.0f, rotation.w).rotateY((float)Math.PI);
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        float scale = 20.0f;
        for (LucyTheAxeHandler.Stack stack : stacks) {
            poseStack.pushPose();
            poseStack.translate(stack.x - x, stack.y - y, stack.z - z);
            poseStack.mulPose(quaternion);
            poseStack.scale(-1.0f / scale, -1.0f / scale, -1.0f / scale);
            minecraft.font.renderText(stack.dialog.getVisualOrderText(), (float)minecraft.font.width((FormattedText)stack.dialog) * -0.5f, 0.0f, -5636096, false, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

