/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity.bestiary;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Zombie;
import org.confluence.terraentity.init.entity.TEMonsterEntities;

public class SlimeZombieRenderer
extends ZombieRenderer {
    private Slime slime;
    private boolean failed = false;

    public SlimeZombieRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(Zombie zombie, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (!this.failed && this.slime == null) {
            this.slime = (Slime)((EntityType)TEMonsterEntities.BLUE_SLIME.get()).create(zombie.level());
            if (this.slime == null) {
                this.failed = true;
            }
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.5f, 0.0f);
        poseStack.scale(0.9f, 0.9f, 0.9f);
        if (!this.failed) {
            this.slime.setXRot(zombie.getXRot());
            this.slime.setYRot(zombie.getYRot());
            this.slime.yBodyRot = zombie.yBodyRot;
            this.slime.yHeadRot = zombie.yHeadRot;
            this.entityRenderDispatcher.render((Entity)this.slime, zombie.getX(), zombie.getY() + 1.5, zombie.getZ(), entityYaw, partialTicks, poseStack, buffer, packedLight);
            this.slime.yBodyRotO = zombie.yBodyRotO;
            this.slime.yHeadRotO = zombie.yHeadRotO;
        }
        super.render((LivingEntity)zombie, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.popPose();
    }
}

