/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.mod.common.entity.TreasureBagItemEntity;
import org.confluence.mod.util.DateUtils;
import org.joml.Matrix4f;

public class TreasureBagRenderer
extends ItemEntityRenderer {
    private static final float length = 1.0f;
    private static final float width = 0.4f;
    private final long time;

    public TreasureBagRenderer(EntityRendererProvider.Context context) {
        super(context);
        Calendar instance = DateUtils.getCalendar();
        int year = instance.get(1);
        int month = instance.get(2) + 1;
        int day = instance.get(5);
        this.time = Long.parseLong(String.valueOf(year) + String.valueOf(month < 10 ? "0" + month : Integer.valueOf(month)) + String.valueOf(day < 10 ? "0" + day : Integer.valueOf(day)));
    }

    public void render(ItemEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        TreasureBagItemEntity entity1;
        if (entity instanceof TreasureBagItemEntity && (entity1 = (TreasureBagItemEntity)entity).isOwner((Player)Minecraft.getInstance().player)) {
            this.shadowStrength = 1.0f;
            super.render(entity, entityYaw, partialTicks, poseStack, buffer, 0xF000F0);
            float delta = ((float)entity.level().getGameTime() + partialTicks) / 200.0f;
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.lightning());
            poseStack.pushPose();
            float y = Mth.sin((float)(((float)entity.getAge() + partialTicks) / 10.0f + entity.bobOffs)) * 0.1f;
            poseStack.translate(0.0f, 0.35f + y, 0.0f);
            LegacyRandomSource randomSource = new LegacyRandomSource(this.time);
            for (int i = 0; i < 12; ++i) {
                poseStack.mulPose(Axis.XP.rotationDegrees((float)(i * randomSource.nextInt(60)) + delta * (float)randomSource.nextInt(30)));
                poseStack.mulPose(Axis.YN.rotationDegrees((float)(i * randomSource.nextInt(60)) + delta * (float)randomSource.nextInt(60)));
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)(i * randomSource.nextInt(60)) + delta * (float)randomSource.nextInt(90)));
                Matrix4f matrix4f = poseStack.last().pose();
                TreasureBagRenderer.vertex1(vertexConsumer, matrix4f, (RandomSource)randomSource);
                TreasureBagRenderer.vertex2(vertexConsumer, matrix4f, (RandomSource)randomSource);
                TreasureBagRenderer.vertex3(vertexConsumer, matrix4f, (RandomSource)randomSource);
                TreasureBagRenderer.vertex4(vertexConsumer, matrix4f, (RandomSource)randomSource);
            }
            poseStack.popPose();
        } else {
            this.shadowStrength = 0.0f;
        }
    }

    private static void vertex1(VertexConsumer vertexConsumer, Matrix4f matrix4f, RandomSource randomSource) {
        vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(randomSource.nextInt(255), randomSource.nextInt(255), randomSource.nextInt(255), 255);
    }

    private static void vertex2(VertexConsumer vertexConsumer, Matrix4f matrix4f, RandomSource randomSource) {
        vertexConsumer.addVertex(matrix4f, -LibClientUtils.HALF_SQRT_3 * 0.4f, 1.0f, -0.2f).setColor(randomSource.nextInt(255), randomSource.nextInt(255), randomSource.nextInt(255), 0);
    }

    private static void vertex3(VertexConsumer vertexConsumer, Matrix4f matrix4f, RandomSource randomSource) {
        vertexConsumer.addVertex(matrix4f, LibClientUtils.HALF_SQRT_3 * 0.4f, 1.0f, -0.2f).setColor(randomSource.nextInt(255), randomSource.nextInt(255), randomSource.nextInt(255), 0);
    }

    private static void vertex4(VertexConsumer vertexConsumer, Matrix4f matrix4f, RandomSource randomSource) {
        vertexConsumer.addVertex(matrix4f, 0.0f, 1.0f, 0.4f).setColor(randomSource.nextInt(255), randomSource.nextInt(255), randomSource.nextInt(255), 0);
    }
}

