/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.util.ClientUtils;
import org.confluence.terra_curio.client.handler.InformationHandler;

public class MechanicalBlockRenderer<E extends AbstractMechanicalBlock.BEntity>
implements BlockEntityRenderer<E> {
    public boolean shouldRenderOffScreen(E blockEntity) {
        return InformationHandler.hasMechanicalView();
    }

    public int getViewDistance() {
        return InformationHandler.hasMechanicalView() ? 256 : super.getViewDistance();
    }

    public boolean shouldRender(AbstractMechanicalBlock.BEntity blockEntity, Vec3 cameraPos) {
        return InformationHandler.hasMechanicalView() && blockEntity.getBlockPos().getCenter().multiply(1.0, 0.0, 1.0).closerThan((Position)cameraPos.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public AABB getRenderBoundingBox(E blockEntity) {
        return ClientUtils.getRenderBoundingBox3x(blockEntity.getBlockPos());
    }

    public void render(E blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        long gameTime = Minecraft.getInstance().level == null ? System.currentTimeMillis() / 50L : Minecraft.getInstance().level.getGameTime();
        Vec3 vec31 = blockEntity.getBlockPos().getCenter();
        for (Int2ObjectMap.Entry entry : ((AbstractMechanicalBlock.BEntity)blockEntity).getConnectedPoses().int2ObjectEntrySet()) {
            int color = entry.getIntKey();
            for (BlockPos pos : (Set)entry.getValue()) {
                poseStack.pushPose();
                Vec3 subtract = pos.getCenter().subtract(vec31);
                Vec3 normalize = subtract.normalize();
                poseStack.translate(0.5f, 0.5f, 0.5f);
                poseStack.mulPose(Axis.YP.rotation(1.5707964f - (float)Math.atan2(normalize.z, normalize.x)));
                poseStack.mulPose(Axis.XP.rotation((float)Math.acos(normalize.y)));
                poseStack.translate(-0.5f, 0.0f, -0.5f);
                int height = (int)Math.round(subtract.length());
                BeaconRenderer.renderBeaconBeam((PoseStack)poseStack, (MultiBufferSource)bufferSource, (ResourceLocation)BeaconRenderer.BEAM_LOCATION, (float)partialTick, (float)1.0f, (long)gameTime, (int)0, (int)height, (int)color, (float)0.2f, (float)0.25f);
                poseStack.popPose();
            }
        }
    }
}

