/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.block;

import java.util.Hashtable;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.functional.DeathChestBlock;
import org.confluence.mod.common.init.block.ChestBlocks;

public class DeathChestBlockRenderer
extends ChestRenderer<DeathChestBlock.BEntity> {
    private final BiFunction<Block, ChestType, Material> function = new BiFunction<Block, ChestType, Material>(this){
        private final Material[] defaultMaterials = new Material[]{Sheets.CHEST_TRAP_LOCATION, Sheets.CHEST_TRAP_LOCATION_LEFT, Sheets.CHEST_TRAP_LOCATION_RIGHT};
        private final Hashtable<Block, Material[]> cache = (Hashtable)Util.make(new Hashtable(), map -> {
            for (DeferredBlock<DeathChestBlock> deathChest : ChestBlocks.DEATH_CHESTS) {
                String chestName = deathChest.getId().getPath().replace("_chest", "");
                ResourceLocation location = Confluence.asResource("entity/chest/" + chestName);
                map.put((Block)deathChest.get(), new Material[]{new Material(Sheets.CHEST_SHEET, location), new Material(Sheets.CHEST_SHEET, location.withSuffix("_left")), new Material(Sheets.CHEST_SHEET, location.withSuffix("_right"))});
            }
        });

        @Override
        public Material apply(Block block, ChestType chestType) {
            return this.cache.getOrDefault(block, this.defaultMaterials)[chestType.ordinal()];
        }
    };

    public DeathChestBlockRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(DeathChestBlock.BEntity blockEntity, ChestType chestType) {
        return this.function.apply(blockEntity.getBlockState().getBlock(), chestType);
    }
}

