/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.block;

import java.util.Hashtable;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.common.BaseChestBlock;
import org.confluence.mod.common.init.block.ChestBlocks;

public class BaseChestBlockRenderer
extends ChestRenderer<BaseChestBlock.BEntity> {
    private final BiFunction<BlockState, ChestType, Material> function = new BiFunction<BlockState, ChestType, Material>(this){
        private final Material[] defaultMaterials = new Material[]{Sheets.CHEST_LOCATION, Sheets.CHEST_LOCATION_LEFT, Sheets.CHEST_LOCATION_RIGHT};
        private final Hashtable<Block, Material[]> unlockedCache = (Hashtable)Util.make(new Hashtable(), map -> {
            for (DeferredBlock<BaseChestBlock> normalChest : ChestBlocks.NORMAL_CHESTS) {
                String chestName = "unlocked_" + normalChest.getId().getPath().replace("_chest", "");
                ResourceLocation location = Confluence.asResource("entity/chest/" + chestName);
                map.put((Block)normalChest.get(), new Material[]{new Material(Sheets.CHEST_SHEET, location), new Material(Sheets.CHEST_SHEET, location.withSuffix("_left")), new Material(Sheets.CHEST_SHEET, location.withSuffix("_right"))});
            }
        });
        private final Hashtable<Block, Material[]> lockedCache = (Hashtable)Util.make(new Hashtable(), map -> {
            for (DeferredBlock<BaseChestBlock> normalChest : ChestBlocks.NORMAL_CHESTS) {
                String chestName = "locked_" + normalChest.getId().getPath().replace("_chest", "");
                ResourceLocation locked = Confluence.asResource("entity/chest/" + chestName);
                map.put((Block)normalChest.get(), new Material[]{new Material(Sheets.CHEST_SHEET, locked), new Material(Sheets.CHEST_SHEET, locked.withSuffix("_left")), new Material(Sheets.CHEST_SHEET, locked.withSuffix("_right"))});
            }
        });

        @Override
        public Material apply(BlockState blockState, ChestType chestType) {
            if (((Boolean)blockState.getValue((Property)BaseChestBlock.UNLOCKED)).booleanValue()) {
                return this.unlockedCache.getOrDefault(blockState.getBlock(), this.defaultMaterials)[chestType.ordinal()];
            }
            return this.lockedCache.getOrDefault(blockState.getBlock(), this.defaultMaterials)[chestType.ordinal()];
        }
    };

    public BaseChestBlockRenderer(BlockEntityRendererProvider.Context pContext) {
        super(pContext);
    }

    protected Material getMaterial(BaseChestBlock.BEntity blockEntity, ChestType chestType) {
        return this.function.apply(blockEntity.getBlockState(), chestType);
    }
}

