/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.confluence.mod.client.model.block.AltarBlockModel;
import org.confluence.mod.common.block.functional.crafting.AltarBlock;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class AltarBlockRenderer
extends GeoBlockRenderer<AltarBlock.BEntity> {
    private long TIME_BEFORE = 0L;

    public AltarBlockRenderer(BlockEntityRendererProvider.Context context) {
        super((GeoModel)new AltarBlockModel());
    }

    public void render(AltarBlock.BEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        long timeVariable;
        super.render((BlockEntity)blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        this.TIME_BEFORE = timeVariable = System.currentTimeMillis() / 20L % 10000L;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            ItemStack itemStack = blockEntity.getItem(i);
            if (itemStack.isEmpty()) continue;
            items.add(itemStack);
        }
        int itemCount = items.size();
        double radius = 0.4 + 0.25 * Math.sqrt(itemCount);
        double rotate = Math.PI * 2 / (double)itemCount;
        float scale = 1.0f;
        int i = 0;
        for (ItemStack itemStack : items) {
            poseStack.pushPose();
            double rotateToDraw = (double)this.TIME_BEFORE * 0.05 * Math.sqrt(itemCount) + rotate * (double)i;
            double offsetX = Math.cos(rotateToDraw) * radius;
            double offsetZ = Math.sin(rotateToDraw) * radius;
            poseStack.translate(0.5 + offsetX, 1.5, 0.5 + offsetZ);
            poseStack.scale(scale, scale, scale);
            double distance = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
            if (distance > 0.0) {
                double dirX = -offsetX / distance;
                double dirZ = -offsetZ / distance;
                float angle = (float)Math.toDegrees(Math.atan2(dirZ, dirX));
                poseStack.mulPose(Axis.YP.rotationDegrees(angle));
            }
            Minecraft.getInstance().getItemRenderer().render(itemStack, ItemDisplayContext.GROUND, false, poseStack, bufferSource, 255, packedOverlay, Minecraft.getInstance().getItemRenderer().getModel(itemStack, null, null, 0));
            poseStack.popPose();
            ++i;
        }
    }
}

