/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.particle.WholeItemParticleOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WholeItemParticle
extends TextureSheetParticle {
    private final ItemStack item;
    private final float roll;
    private final float yaw;
    private final float pitch;

    public WholeItemParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ItemStack item, float gravity, int life) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.item = item;
        this.gravity = gravity;
        this.lifetime = life;
        this.roll = this.random.nextFloat() * ((float)Math.PI * 2);
        this.yaw = this.random.nextFloat() * ((float)Math.PI * 2);
        this.pitch = this.random.nextFloat() * ((float)Math.PI * 2);
    }

    public void tick() {
        super.tick();
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(@NotNull VertexConsumer buffer, Camera camera, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = new PoseStack();
        double x = Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x);
        double y = Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y);
        double z = Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z);
        poseStack.pushPose();
        poseStack.translate(x - camera.getPosition().x, y - camera.getPosition().y, z - camera.getPosition().z);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(Axis.ZP.rotation(this.roll).rotateX(this.pitch).rotateY(this.yaw));
        mc.getItemRenderer().renderStatic(this.item, ItemDisplayContext.NONE, 0xF000F0, OverlayTexture.NO_OVERLAY, poseStack, (MultiBufferSource)mc.renderBuffers().bufferSource(), (Level)this.level, 0);
        mc.renderBuffers().bufferSource().endBatch();
        poseStack.popPose();
    }

    public static class Provider
    implements ParticleProvider<WholeItemParticleOptions> {
        @Nullable
        public Particle createParticle(WholeItemParticleOptions options, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new WholeItemParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options.item(), options.gravity(), options.life());
        }
    }
}

