/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.network.s2c.MeteoriteLocationPacketS2C;
import org.confluence.mod.util.OverworldUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public final class MeteorLandingHandler {
    private static final ResourceLocation TEXTURE = Confluence.asResource("textures/environment/meteor.png");
    private static final float RADIUS = 5.0f;
    private static final PoseStack poseStack = new PoseStack();
    @Nullable
    private static GlobalPos globalPos = null;
    @Nullable
    private static Vec3 location = null;
    private static int tickUntilLanding = 0;
    private static int totalLandingTick = 0;
    private static float alpha = 0.0f;
    private static float pitch = -1.5707964f;
    private static float pitchO = -1.5707964f;
    private static float yaw = 1.5707964f;
    private static float yawO = 1.5707964f;
    @Nullable
    private static Vec3 vector = null;
    private static double distance = 0.0;
    private static float v0 = 0.0f;
    private static float v1 = 0.0f;

    public static void reset() {
        globalPos = null;
        location = null;
        tickUntilLanding = 0;
    }

    public static void handle(Minecraft minecraft, Player player) {
        if (minecraft.isPaused()) {
            return;
        }
        if (tickUntilLanding > 0) {
            pitchO = pitch;
            yawO = yaw;
            MeteorLandingHandler.calculate(player);
            v0 = 0.25f * (float)((--tickUntilLanding >> 1) % 4);
            v1 = v0 + 0.25f;
        } else {
            location = null;
        }
    }

    public static void handlePacket(MeteoriteLocationPacketS2C packet, Player player) {
        globalPos = GlobalPos.of(OverworldUtils.dimension(), (BlockPos)packet.location());
        if (packet.tickUntilLanding() <= 0) {
            location = null;
            tickUntilLanding = 0;
            return;
        }
        location = packet.location().getCenter();
        totalLandingTick = tickUntilLanding = packet.tickUntilLanding();
        MeteorLandingHandler.calculate(player);
        pitchO = pitch;
        yawO = yaw;
    }

    private static void calculate(Player player) {
        assert (location != null);
        vector = player.position().subtract(location);
        distance = vector.length() * 0.0625;
        Vec3 vec = vector.normalize();
        alpha = 1.0f - (float)tickUntilLanding / (float)totalLandingTick;
        float ratio = Mth.lerp((float)alpha, (float)0.3f, (float)1.0f);
        pitch = -1.5707964f * ratio;
        yaw = 1.5707964f * ratio - (float)Math.atan2(vec.z, vec.x);
    }

    public static void render(RenderLevelStageEvent event) {
        if (location == null || vector == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null || player.level().dimension() != OverworldUtils.dimension()) {
            return;
        }
        if (distance < event.getLevelRenderer().getLastViewDistance()) {
            return;
        }
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        poseStack.pushPose();
        poseStack.mulPose(event.getModelViewMatrix());
        poseStack.mulPose(Axis.YP.rotation(Mth.lerp((float)partialTick, (float)yawO, (float)yaw)).rotateX(Mth.lerp((float)partialTick, (float)pitchO, (float)pitch)));
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        Matrix4f matrix4f = poseStack.last().pose().rotate((Quaternionfc)LibClientUtils.ANGLE_45);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferBuilder.addVertex(matrix4f, -5.0f, 100.0f, -5.0f).setUv(0.0f, v1).setColor(1.0f, 1.0f, 1.0f, alpha);
        bufferBuilder.addVertex(matrix4f, 5.0f, 100.0f, -5.0f).setUv(1.0f, v1).setColor(1.0f, 1.0f, 1.0f, alpha);
        bufferBuilder.addVertex(matrix4f, 5.0f, 100.0f, 5.0f).setUv(1.0f, v0).setColor(1.0f, 1.0f, 1.0f, alpha);
        bufferBuilder.addVertex(matrix4f, -5.0f, 100.0f, 5.0f).setUv(0.0f, v0).setColor(1.0f, 1.0f, 1.0f, alpha);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    @Nullable
    public static GlobalPos getGlobalPos() {
        return globalPos;
    }
}

