/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.common.attachment.EverBeneficial;
import org.confluence.mod.common.attachment.PlayerSpecialData;
import org.confluence.mod.common.data.saved.GlobalCloakData;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.mixed.IDeathScreen;
import org.confluence.mod.mixed.ILevelRenderer;
import org.confluence.mod.network.s2c.FishingPowerInfoPacketS2C;
import org.confluence.mod.network.s2c.ManaPacketS2C;
import org.confluence.mod.network.s2c.PlayerDeathInfoPacketS2C;
import org.confluence.mod.network.s2c.SecretFlagSyncPacketS2C;
import org.confluence.mod.network.s2c.SoulPacketS2C;
import org.confluence.mod.util.ClientUtils;
import org.confluence.terra_curio.common.init.TCItems;

public final class ClientPacketHandler {
    private static int maxMana = 20;
    private static float currentMana = 20.0f;
    private static int maxSoul = 10;
    private static float currentSoul = 10.0f;
    private static float fishingPower = 0.0f;
    private static boolean echoVisible = false;
    private static long secretFlag = 0L;
    private static boolean showSignal = false;
    private static boolean fallenSoulCoreActive = false;
    private static int luminance = 0;
    private static final Int2IntMap remoteLuminance = new Int2IntArrayMap();

    public static float getCurrentMana() {
        return currentMana;
    }

    public static int getMaxMana() {
        return maxMana;
    }

    public static float getCurrentSoul() {
        return currentSoul;
    }

    public static int getMaxSoul() {
        return maxSoul;
    }

    public static boolean isFallenSoulCoreActive() {
        return fallenSoulCoreActive;
    }

    public static float getFishingPower() {
        return fishingPower;
    }

    public static boolean hasEchoVisible() {
        return echoVisible;
    }

    public static long getSecretFlag() {
        return secretFlag;
    }

    public static boolean isShowSignal() {
        return showSignal;
    }

    public static int getLuminance(Player player) {
        return player == Minecraft.getInstance().player ? luminance : remoteLuminance.getOrDefault(player.getId(), 0);
    }

    public static void setLuminance(Player player, PlayerSpecialData data) {
        if (player == Minecraft.getInstance().player) {
            luminance = (Integer)data.getValue(TCItems.LUMINANCE);
        } else {
            remoteLuminance.put(player.getId(), ((Integer)data.getValue(TCItems.LUMINANCE)).intValue());
        }
    }

    public static void reset() {
        maxMana = 20;
        currentMana = 20.0f;
        maxSoul = 10;
        currentSoul = 10.0f;
        fishingPower = 0.0f;
        echoVisible = false;
        secretFlag = 0L;
        showSignal = false;
        luminance = 0;
        remoteLuminance.clear();
        fallenSoulCoreActive = false;
    }

    public static void handleMana(ManaPacketS2C packet, Player player) {
        maxMana = packet.maxMana();
        currentMana = packet.currentMana();
        if (currentMana >= (float)maxMana) {
            player.playSound((SoundEvent)ModSoundEvents.COOLDOWN_RECOVERY.get());
        }
    }

    public static void handleSoul(SoulPacketS2C packet, Player player) {
        maxSoul = packet.maxSoul();
        currentSoul = packet.currentSoul();
        fallenSoulCoreActive = packet.fallenSoulCoreActive();
        EverBeneficial beneficial = EverBeneficial.of((LivingEntity)player);
        beneficial.setFallenSoulCore(fallenSoulCoreActive);
        PlayerSpecialData data = PlayerSpecialData.of(player);
        data.setFallenSoulCoreActive(beneficial.getFallenSoulCore());
    }

    public static void handleFishingPower(FishingPowerInfoPacketS2C packet) {
        fishingPower = packet.value();
    }

    public static void handleVisibility(byte mask, boolean visible) {
        if ((mask & 2) != 0 && echoVisible != visible) {
            ILevelRenderer.rebuildAllChunks();
            echoVisible = visible;
        }
        if ((mask & 4) != 0) {
            ClientUtils.postTheConstantEffect(visible);
        }
        if ((mask & 8) != 0) {
            showSignal = visible;
        }
    }

    public static void handleSecretFlag(SecretFlagSyncPacketS2C packet) {
        secretFlag = packet.flag();
        if ((secretFlag & 4L) != 0L) {
            ILevelRenderer.rebuildAllChunks();
        }
    }

    public static void handleDeathInfo(PlayerDeathInfoPacketS2C packet, Player player) {
        Screen screen;
        ((LocalPlayer)player).connection.handlePlayerCombatKill(new ClientboundPlayerCombatKillPacket(player.getId(), packet.deathMessage()));
        if (!player.isCreative() && (screen = Minecraft.getInstance().screen) instanceof IDeathScreen) {
            IDeathScreen deathScreen = (IDeathScreen)screen;
            deathScreen.confluence$setDelayTicker(0);
            deathScreen.confluence$setRespawnWaitTime(packet.respawnTime() * 20);
            if (packet.platinum() != 0 || packet.gold() != 0 || packet.silver() != 0 || packet.copper() != 0) {
                MutableComponent component = Component.translatable((String)"info.confluence.drops_money");
                if (packet.platinum() > 0) {
                    component.append((Component)Component.translatable((String)"info.confluence.drops_money.platinum", (Object[])new Object[]{packet.platinum()}));
                }
                if (packet.gold() > 0) {
                    component.append((Component)Component.translatable((String)"info.confluence.drops_money.gold", (Object[])new Object[]{packet.gold()}));
                }
                if (packet.silver() > 0) {
                    component.append((Component)Component.translatable((String)"info.confluence.drops_money.silver", (Object[])new Object[]{packet.silver()}));
                }
                if (packet.copper() > 0) {
                    component.append((Component)Component.translatable((String)"info.confluence.drops_money.copper", (Object[])new Object[]{packet.copper()}));
                }
                deathScreen.confluence$setDropsMoney(component);
            }
        }
    }

    public static void handleFlushArmorSetBonus(Player localPlayer, int playerId) {
        Entity entity = localPlayer.level().getEntity(playerId);
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)entity;
            if (localPlayer == clientPlayer) {
                PlayerSpecialData.of(localPlayer).flushArmorSetBonus(localPlayer);
            } else {
                PlayerSpecialData.of((Player)clientPlayer).flushArmorSetBonus((Player)clientPlayer);
            }
        }
    }

    public static void handleCloak() {
        GlobalCloakData.INSTANCE.rollbackAllProperties();
        ILevelRenderer.rebuildAllChunks();
    }
}

