/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui.hud;

import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.client.handler.ClientPacketHandler;
import org.confluence.mod.util.ClientUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TerraStyleManaHud
implements LayeredDraw.Layer {
    private static final int[] MANA = new int[]{5931746, 10635479};
    private static final int[] MANA_LOW = new int[]{6099386, 11278993};
    private static final int[] MANA_HIGH = new int[]{9482232, 16749757};

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui || !LibClientUtils.shouldDrawSurvivalElements((Minecraft)minecraft)) {
            return;
        }
        LibClientUtils.setupOverlayRenderState((boolean)true, (boolean)false);
        minecraft.getProfiler().push("terra_style_hud");
        ClientConfigs.manaStyle.render(guiGraphics, minecraft);
        minecraft.getProfiler().pop();
    }

    public static enum Mana implements TranslatableEnum
    {
        LEGACY{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
                if (minecraft.player != null && ClientPacketHandler.isFallenSoulCoreActive()) {
                    return;
                }
                int widthMana = guiGraphics.guiWidth() - 21 + ClientConfigs.manaOffsetX;
                int heightMana = 4 + ClientConfigs.manaOffsetY;
                float currentMana = ClientPacketHandler.getCurrentMana();
                int maxManaCount = ClientPacketHandler.getMaxMana() / 20;
                for (int i = 0; i < maxManaCount; ++i) {
                    float currentManaToBlit = currentMana - (float)((i + 1) * 20);
                    guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, 0, 34, widthMana, heightMana + i * 12, 17, 16);
                    if (currentManaToBlit >= 0.0f) {
                        guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, 18, 34, widthMana + 2, heightMana + i * 12, 13, 16);
                        continue;
                    }
                    if (!(currentManaToBlit + 20.0f >= 0.0f)) continue;
                    float ts = (currentManaToBlit + 20.0f) / 20.0f;
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate((float)(widthMana + 2) + 6.5f * (1.0f - ts), (float)(heightMana + i * 12) + 8.5f * (1.0f - ts), 0.0f);
                    guiGraphics.pose().scale(ts, ts, 1.0f);
                    guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, 18, 34, 0, 0, 13, 16);
                    guiGraphics.pose().popPose();
                }
            }
        }
        ,
        OVERLAY{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
                if (minecraft.player != null && ClientPacketHandler.isFallenSoulCoreActive()) {
                    return;
                }
                float currentMana = ClientPacketHandler.getCurrentMana() / 10.0f;
                float maxMana = (float)ClientPacketHandler.getMaxMana() / 10.0f;
                int widthMana = guiGraphics.guiWidth() / 2 + 10 + ClientConfigs.manaOffsetX;
                int heightMana = guiGraphics.guiHeight() - minecraft.gui.rightHeight + ClientConfigs.manaOffsetY;
                minecraft.gui.rightHeight += 10;
                RandomSource random = RandomSource.create((long)1919810L);
                ClientUtils.colorDraw(guiGraphics, minecraft, random, ClientUtils.OVERLAY_TEXTURE, MANA, MANA_HIGH, MANA_LOW, maxMana, currentMana, widthMana, heightMana, 128, 10, false);
            }
        };


        public abstract void render(GuiGraphics var1, Minecraft var2);

        public Component getTranslatedName() {
            return Component.translatable((String)("confluence.configuration.manaStyle." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

