/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui.hud;

import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.util.ClientUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TerraStyleFoodHud
implements LayeredDraw.Layer {
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!ClientConfigs.terraStyleFood) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui || !LibClientUtils.shouldDrawSurvivalElements((Minecraft)minecraft)) {
            return;
        }
        LibClientUtils.setupOverlayRenderState((boolean)true, (boolean)false);
        minecraft.getProfiler().push("terra_style_hud");
        ClientConfigs.foodStyle.render(guiGraphics, minecraft);
        minecraft.getProfiler().pop();
    }

    public static enum Food implements TranslatableEnum
    {
        LEGACY{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
            }
        }
        ,
        OVERLAY{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
                float food = 0.0f;
                float foodSaturation = 0.0f;
                boolean hunger = false;
                LocalPlayer player = minecraft.player;
                if (player != null) {
                    food = player.getFoodData().getFoodLevel();
                    foodSaturation = player.getFoodData().getSaturationLevel();
                    hunger = player.hasEffect(MobEffects.HUNGER);
                }
                int foodI = (int)food;
                int foodSaturationI = (int)foodSaturation;
                if ((float)foodI - food > 0.0f) {
                    ++foodI;
                }
                if ((float)foodSaturationI - foodSaturation > 0.0f) {
                    ++foodSaturationI;
                }
                int white = 0xFFFFFF;
                int widthFood = guiGraphics.guiWidth() / 2 + 10;
                int heightFood = guiGraphics.guiHeight() - minecraft.gui.rightHeight;
                minecraft.gui.rightHeight += 10;
                for (int i = 0; i < 10; ++i) {
                    guiGraphics.blitSprite(ClientUtils.OVERLAY_TEXTURE, 128, 128, 60, 30, widthFood + i * 8, heightFood, 9, 9);
                }
                if (hunger) {
                    ClientUtils.draw(widthFood, heightFood, guiGraphics, foodI, white, white, white, ClientUtils.OVERLAY_TEXTURE, 128, 20, 30, false, 1, 20);
                } else {
                    ClientUtils.draw(widthFood, heightFood, guiGraphics, foodI, white, white, white, ClientUtils.OVERLAY_TEXTURE, 128, 0, 30, false, 1, 20);
                }
                ClientUtils.draw(widthFood, heightFood, guiGraphics, foodSaturationI, white, white, white, ClientUtils.OVERLAY_TEXTURE, 128, 40, 30, false, 1, 20);
            }
        };


        public abstract void render(GuiGraphics var1, Minecraft var2);

        public Component getTranslatedName() {
            return Component.translatable((String)("confluence.configuration.foodStyle." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

