/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui.hud;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.confluence.mod.common.component.RepeaterContents;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.item.crossbow.BaseTerraRepeaterItem;
import org.confluence.mod.mixed.IGui;

public class RepeaterHud
implements LayeredDraw.Layer {
    public static final boolean DYNAMICCROSSHAIR = ModList.get().isLoaded("dynamiccrosshair");

    public static void handle() {
        IGui.of(Minecraft.getInstance().gui).confluence$setShooting();
    }

    public static void renderCrosshair(Gui gui, GuiGraphics instance, ResourceLocation sprite, int x, int y, int width, int height, Operation<Void> original, DeltaTracker deltaTracker) {
        IGui igui = IGui.of(gui);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || DYNAMICCROSSHAIR) {
            original.call(new Object[]{instance, sprite, x, y, width, height});
            return;
        }
        PoseStack pose = instance.pose();
        pose.pushPose();
        float v = (float)width / 2.0f;
        float v1 = (float)height / 2.0f;
        pose.translate((float)x + v, (float)y + v1, 0.0f);
        ItemStack itemStack = player.getMainHandItem();
        float end = 0.0f;
        Item item = itemStack.getItem();
        if (item instanceof BaseTerraRepeaterItem) {
            BaseTerraRepeaterItem repeaterItem = (BaseTerraRepeaterItem)item;
            if (player.isUsingItem() && player.getUseItem().equals(itemStack)) {
                end = Math.clamp(igui.confluence$getOldRepeaterCrosshairAngle() + 360.0f / (float)repeaterItem.getReloadSpeed((LivingEntity)player, itemStack), 0.0f, 720.0f);
            } else if (!((RepeaterContents)itemStack.getOrDefault(ModDataComponentTypes.REPEATER_CONTENTS.get(), (Object)RepeaterContents.EMPTY)).isEmpty()) {
                end = 45.0f;
            }
        }
        float timeDeltaPartialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        float v2 = Mth.lerp((float)(timeDeltaPartialTick / 2.0f), (float)igui.confluence$getOldRepeaterCrosshairAngle(), (float)end);
        pose.mulPose(Axis.ZN.rotationDegrees(v2 % 360.0f));
        float scale = 1.0f + 0.5f * (igui.confluence$getScale() / 2.0f);
        pose.scale(scale, scale, 1.0f);
        igui.confluence$setOldRepeaterCrosshairAngle(v2);
        igui.confluence$setScale(Math.max(1.0f, igui.confluence$getScale() - timeDeltaPartialTick));
        pose.translate(-v, -v1, 0.0f);
        original.call(new Object[]{instance, sprite, 0, 0, width, height});
        pose.popPose();
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.getMainHandItem();
        if (!(itemStack.getItem() instanceof BaseTerraRepeaterItem)) {
            return;
        }
        RepeaterContents repeaterContents = (RepeaterContents)itemStack.getOrDefault(ModDataComponentTypes.REPEATER_CONTENTS.get(), (Object)RepeaterContents.EMPTY);
        if (repeaterContents.isEmpty()) {
            return;
        }
        int x = guiGraphics.guiWidth() / 2;
        int y = guiGraphics.guiHeight() / 2;
        int slotSize = repeaterContents.getUedSlotSize();
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        int I = 5;
        float I1 = 6.0f;
        for (int i = 0; i < slotSize && i <= 5; ++i) {
            ItemStack stack = repeaterContents.getStackInSlot(i);
            pose.pushPose();
            float g = (float)i * 0.1f;
            float scale = 1.0f - g;
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, (float)(5 - i) / 6.0f);
            pose.translate((float)x - (float)x * scale, (float)y - (float)y * scale, 0.0f);
            pose.scale(scale, scale, 1.0f);
            guiGraphics.renderItem(stack, x, y);
            guiGraphics.renderItemDecorations(minecraft.font, stack, x, y);
            x += Mth.floor((float)16.0f);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            pose.popPose();
        }
        pose.popPose();
    }
}

