/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import org.confluence.mod.client.gui.GuiSprite;
import org.jetbrains.annotations.Nullable;

public class ClickableArea {
    private final int w;
    private final int h;
    private int x;
    private int y;
    @Nullable
    private GuiSprite hovered;

    public ClickableArea(int w, int h) {
        this.w = w;
        this.h = h;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getEndX() {
        return this.x + this.w;
    }

    public int getEndY() {
        return this.y + this.h;
    }

    public ClickableArea setPos(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public ClickableArea setHovered(GuiSprite hovered) {
        this.hovered = hovered;
        return this;
    }

    @Nullable
    public GuiSprite getHovered() {
        return this.hovered;
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)this.getEndX() && mouseY >= (double)this.y && mouseY < (double)this.getEndY();
    }

    public void renderHovered(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.hovered != null && this.hovered.isHovered(mouseX, mouseY)) {
            this.hovered.render(guiGraphics);
        }
    }
}

