/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModSoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AchievementToast
implements Toast {
    public static final Component DISPLAY = Component.translatable((String)"achievements.toast.complete");
    private static final ResourceLocation TEXTURE = Confluence.asResource("textures/achievement/toast.png");
    private static final Hashtable<ResourceLocation, AchievementToast> ACHIEVEMENTS = new Hashtable();
    private static final Object2BooleanMap<ResourceLocation> HIDE_LINK = new Object2BooleanOpenHashMap();
    private final ResourceLocation icon;
    private final Display display;
    public boolean playedSound;

    public AchievementToast(ResourceLocation icon, Display display) {
        this.icon = icon;
        this.display = display;
        this.playedSound = false;
    }

    public int height() {
        return 64;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        Font font = toastComponent.getMinecraft().font;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, (float)(guiGraphics.guiHeight() - this.height()), 0.0f);
        guiGraphics.blit(TEXTURE, 0, 0, 0.0f, 0.0f, this.width(), this.height(), 160, 64);
        this.renderTitle(guiGraphics, timeSinceLastVisible, font);
        this.renderDescription(guiGraphics, timeSinceLastVisible, font);
        this.renderIcon(guiGraphics);
        guiGraphics.pose().popPose();
        this.playSound(toastComponent, timeSinceLastVisible);
        return (double)timeSinceLastVisible >= 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    private void playSound(ToastComponent toastComponent, long timeSinceLastVisible) {
        if (!this.playedSound && timeSinceLastVisible > 0L) {
            this.playedSound = true;
            if (this.display.type() == AdvancementType.CHALLENGE) {
                toastComponent.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSoundEvents.ACHIEVEMENTS.get()), (float)1.0f, (float)1.0f));
            }
        }
    }

    private void renderDescription(GuiGraphics guiGraphics, long timeSinceLastVisible, Font font) {
        List list = font.split((FormattedText)this.display.description(), 141);
        int size = list.size();
        if (size == 1) {
            guiGraphics.drawString(font, (FormattedCharSequence)list.getFirst(), 8, 44, 0, false);
        } else if (size < 4) {
            int l = 48 - size * 9 / 2;
            for (FormattedCharSequence formattedcharsequence : list) {
                guiGraphics.drawString(font, formattedcharsequence, 8, l, 0, false);
                l += 9;
            }
        } else {
            int times = Mth.ceil((float)((float)size / 3.0f));
            int top = 48 - times * 9 / 2;
            long splitTime = 5000 / times;
            Iterator iterator = list.iterator();
            for (int t = 0; t < times; ++t) {
                long time = splitTime * (long)t;
                if (timeSinceLastVisible < time || timeSinceLastVisible >= time + splitTime) continue;
                long delta = timeSinceLastVisible - time;
                int alpha = t == 0 ? Mth.floor((float)(Mth.clamp((float)((float)(splitTime - delta) / 200.0f), (float)0.0f, (float)1.0f) * 255.0f)) : (t == times - 1 ? Mth.floor((float)(Mth.clamp((float)((float)delta / 200.0f), (float)0.0f, (float)1.0f) * 252.0f)) : (delta < splitTime / 2L ? Mth.floor((float)(Mth.clamp((float)((float)delta / 200.0f), (float)0.0f, (float)1.0f) * 252.0f)) : Mth.floor((float)(Mth.clamp((float)((float)(splitTime - delta) / 200.0f), (float)0.0f, (float)1.0f) * 252.0f))));
                int i = 0;
                while (iterator.hasNext()) {
                    FormattedCharSequence next = (FormattedCharSequence)iterator.next();
                    if (i >= t * 3 && i < (t + 1) * 3) {
                        guiGraphics.drawString(font, next, 8, top, alpha << 24 | 0x4000000, false);
                        top += 9;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void renderIcon(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(4.0f, 4.0f, 0.0f);
        guiGraphics.pose().scale(0.375f, 0.375f, 1.0f);
        guiGraphics.blit(this.icon, 0, 0, 0.0f, 0.0f, 64, 64, 64, 64);
        guiGraphics.pose().popPose();
    }

    private void renderTitle(GuiGraphics guiGraphics, long timeSinceLastVisible, Font font) {
        int i;
        List list = font.split((FormattedText)this.display.title(), 125);
        int n = i = this.display.type() == AdvancementType.CHALLENGE ? 0xFF88FF : 0xFFFF00;
        if (list.size() == 1) {
            guiGraphics.drawString(font, DISPLAY, 30, 7, i | 0xFF000000, false);
            guiGraphics.drawString(font, (FormattedCharSequence)list.getFirst(), 30, 18, -1, false);
        } else if (timeSinceLastVisible < 1500L) {
            int k = Mth.floor((float)(Mth.clamp((float)((float)(1500L - timeSinceLastVisible) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            guiGraphics.drawString(font, DISPLAY, 30, 11, i | k, false);
        } else {
            int i1 = Mth.floor((float)(Mth.clamp((float)((float)(timeSinceLastVisible - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int l = 16 - list.size() * 9 / 2;
            for (FormattedCharSequence formattedcharsequence : list) {
                guiGraphics.drawString(font, formattedcharsequence, 30, l, 0xFFFFFF | i1, false);
                l += 9;
            }
        }
    }

    public static boolean renderWidgetIcon(ResourceLocation id, GuiGraphics guiGraphics, int x, int y) {
        AchievementToast achievementToast = AchievementToast.getToast(id);
        if (achievementToast == null) {
            return true;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        guiGraphics.pose().scale(0.25f, 0.25f, 1.0f);
        guiGraphics.blit(achievementToast.icon, 0, 0, 0.0f, 0.0f, 64, 64, 64, 64);
        guiGraphics.pose().popPose();
        return false;
    }

    public static void registerToast(ResourceLocation id, boolean hideLink) {
        String namespace = id.getNamespace();
        String path = id.getPath().substring("achievements/".length());
        ACHIEVEMENTS.put(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("achievements/" + path)), new AchievementToast(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("textures/achievement/" + path + ".png")), new Display(AdvancementType.CHALLENGE, (Component)Component.translatable((String)("achievements." + namespace + "." + path + ".title")), (Component)Component.translatable((String)("achievements." + namespace + "." + path + ".description")))));
        HIDE_LINK.put((Object)id, hideLink);
    }

    @Nullable
    public static AchievementToast getToast(ResourceLocation advancement) {
        return ACHIEVEMENTS.get(advancement);
    }

    public static boolean hideLink(ResourceLocation id, boolean defaultValue) {
        return HIDE_LINK.getOrDefault((Object)id, defaultValue);
    }

    public static void clearToast() {
        ACHIEVEMENTS.clear();
        HIDE_LINK.clear();
    }

    public record Display(AdvancementType type, Component title, Component description) {
    }
}

