/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gameevent;

import com.google.common.collect.EvictingQueue;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.gameevent.ClientGameEventSystem;
import org.confluence.mod.util.OverworldUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

final class MeteorShowerSprite {
    static final ResourceLocation TEXTURE = Confluence.asResource("textures/environment/meteor_shower.png");
    static final Queue<MeteorShowerSprite> SPRITES = EvictingQueue.create((int)32);
    static boolean started;
    static final float frame = 0.14285715f;
    final float radius = 4.0f + ClientGameEventSystem.random() * 2.0f;
    final float alpha = 0.5f + ClientGameEventSystem.random() * 0.5f;
    final Quaternionf quaternionf = new Quaternionf().rotationXYZ(ClientGameEventSystem.random() * -1.5707964f - 0.7853982f, ClientGameEventSystem.random() * 1.5707964f * 0.95f, ClientGameEventSystem.random() * ((float)Math.PI * 2));
    int tick;
    float v0;
    float v1 = 0.14285715f;
    boolean remove;

    MeteorShowerSprite() {
    }

    void render(BufferBuilder builder, float a) {
        ClientGameEventSystem.poseStack.pushPose();
        ClientGameEventSystem.poseStack.mulPose(this.quaternionf);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.alpha * a));
        Matrix4f matrix4f = ClientGameEventSystem.poseStack.last().pose();
        builder.addVertex(matrix4f, -this.radius, 100.0f, -this.radius).setUv(0.0f, this.v1);
        builder.addVertex(matrix4f, this.radius, 100.0f, -this.radius).setUv(1.0f, this.v1);
        builder.addVertex(matrix4f, this.radius, 100.0f, this.radius).setUv(1.0f, this.v0);
        builder.addVertex(matrix4f, -this.radius, 100.0f, this.radius).setUv(0.0f, this.v0);
        ClientGameEventSystem.poseStack.popPose();
    }

    static void renderMeteorShower(LocalPlayer player, RenderLevelStageEvent event) {
        if (player.level().dimension() != OverworldUtils.dimension()) {
            return;
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        float a = Math.max(1.0f - player.level().getRainLevel(partialTick), 0.2f);
        ClientGameEventSystem.poseStack.pushPose();
        ClientGameEventSystem.poseStack.mulPose(event.getModelViewMatrix());
        for (MeteorShowerSprite sprite : SPRITES) {
            sprite.render(builder, a);
        }
        ClientGameEventSystem.poseStack.popPose();
        MeshData data = builder.build();
        if (data != null) {
            BufferUploader.drawWithShader((MeshData)data);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    static void tick(long gameTime) {
        if (!started) {
            return;
        }
        if (gameTime % 2L == 0L) {
            SPRITES.add(new MeteorShowerSprite());
        }
        Iterator iterator = SPRITES.iterator();
        while (iterator.hasNext()) {
            MeteorShowerSprite sprite = (MeteorShowerSprite)iterator.next();
            ++sprite.tick;
            int i = (sprite.tick >> 1) % 7;
            sprite.v0 = 0.14285715f * (float)i;
            sprite.v1 = sprite.v0 + 0.14285715f;
            if (sprite.remove) {
                iterator.remove();
            }
            if (i != 6) continue;
            sprite.remove = true;
        }
    }

    static void handle(Player player, boolean start) {
        started = start;
        if (!start) {
            SPRITES.clear();
        }
    }

    static void reset() {
        started = false;
        SPRITES.clear();
    }
}

