/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gameevent;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.gameevent.ClientGameEventSystem;
import org.confluence.mod.client.handler.WeatherHandler;
import org.confluence.mod.util.OverworldUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.data.molang.compiler.value.Variable;
import org.mesdag.particlestorm.particle.ParticleEmitter;

final class LanternNightSprite {
    static final ResourceLocation TEXTURE = Confluence.asResource("textures/environment/lantern_night.png");
    static final int MAX = 100;
    static final Queue<LanternNightSprite> SPRITES = new ArrayDeque<LanternNightSprite>(100);
    static boolean started;
    static float globalAlpha;
    static float globalY;
    static float globalYO;
    @Nullable
    static ParticleEmitter emitter;
    final float radius = 1.0f + ClientGameEventSystem.random() * 0.5f;
    final float dist;
    final float alpha;
    final float dYaw;
    int tick;
    float step;
    float y;
    float yo;
    float yaw;
    float yawO;
    byte k;

    LanternNightSprite() {
        float v = ClientGameEventSystem.random();
        this.dist = 75.0f + v * 25.0f;
        this.alpha = 1.0f - v * 0.5f;
        this.dYaw = (float)Math.PI * 2 / (ClientGameEventSystem.random() * 1200.0f + 1800.0f);
        this.tick = (int)(ClientGameEventSystem.random() * 2400.0f);
        this.y = 90.0f - ClientGameEventSystem.random() * 100.0f;
        this.cal();
    }

    void cal() {
        byte kO = this.k;
        float v = (float)this.tick * this.dYaw;
        this.k = (byte)Mth.sign((double)Mth.cos((float)v));
        if (kO != this.k) {
            this.step = (ClientGameEventSystem.random() * 7.0f + 3.0f) * this.dYaw;
        }
        this.yo = this.y;
        this.yawO = this.yaw;
        this.yaw = v;
        this.y += (float)this.k * this.step;
    }

    void render(BufferBuilder builder, float partialTick, float a) {
        ClientGameEventSystem.poseStack.pushPose();
        ClientGameEventSystem.poseStack.mulPose(Axis.YP.rotation(Mth.lerp((float)partialTick, (float)this.yawO, (float)this.yaw)).rotateX(-1.5707964f));
        ClientGameEventSystem.poseStack.translate(0.0f, 0.0f, Mth.lerp((float)partialTick, (float)this.yo, (float)this.y));
        Matrix4f matrix4f = ClientGameEventSystem.poseStack.last().pose();
        builder.addVertex(matrix4f, -this.radius, this.dist, -this.radius).setUv(0.0f, 1.0f).setColor(255, 255, 255, (int)(this.alpha * a * 255.0f));
        builder.addVertex(matrix4f, this.radius, this.dist, -this.radius).setUv(1.0f, 1.0f).setColor(255, 255, 255, (int)(this.alpha * a * 255.0f));
        builder.addVertex(matrix4f, this.radius, this.dist, this.radius).setUv(1.0f, 0.0f).setColor(255, 255, 255, (int)(this.alpha * a * 255.0f));
        builder.addVertex(matrix4f, -this.radius, this.dist, this.radius).setUv(0.0f, 0.0f).setColor(255, 255, 255, (int)(this.alpha * a * 255.0f));
        ClientGameEventSystem.poseStack.popPose();
    }

    static void renderLanternNight(LocalPlayer player, RenderLevelStageEvent event) {
        if (player.level().dimension() != OverworldUtils.dimension()) {
            return;
        }
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        float rainLevel = player.level().getRainLevel(partialTick);
        if (rainLevel > 0.99999f) {
            return;
        }
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)globalAlpha);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float a = 1.0f - rainLevel;
        ClientGameEventSystem.poseStack.pushPose();
        ClientGameEventSystem.poseStack.mulPose(event.getModelViewMatrix());
        ClientGameEventSystem.poseStack.translate(0.0f, Mth.lerp((float)partialTick, (float)globalYO, (float)globalY), 0.0f);
        for (LanternNightSprite sprite : SPRITES) {
            sprite.render(builder, partialTick, a);
        }
        ClientGameEventSystem.poseStack.popPose();
        MeshData data = builder.build();
        if (data != null) {
            BufferUploader.drawWithShader((MeshData)data);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    static void tick(LocalPlayer player) {
        int spawn;
        if (!started) {
            return;
        }
        if (globalAlpha < 1.0f) {
            globalAlpha = Math.min(globalAlpha + 0.005f, 1.0f);
        }
        if (globalY < 0.0f) {
            globalYO = globalY;
            globalY += 0.1f;
        } else {
            globalYO = 0.0f;
            globalY = 0.0f;
        }
        if (emitter == null || LanternNightSprite.emitter.pos.distanceToSqr(player.position()) > 1024.0 || emitter.isRemoved()) {
            LanternNightSprite.createOrRemoveEmitter((Player)player);
        }
        if ((spawn = 100 - SPRITES.size()) > 0) {
            for (int i = 0; i < spawn; ++i) {
                SPRITES.add(new LanternNightSprite());
            }
        }
        Iterator iterator = SPRITES.iterator();
        while (iterator.hasNext()) {
            LanternNightSprite sprite = (LanternNightSprite)iterator.next();
            ++sprite.tick;
            sprite.cal();
            if (!(sprite.y > 100.0f) && !(sprite.y < -20.0f)) continue;
            iterator.remove();
        }
    }

    static void handle(Player player, boolean start) {
        if (start) {
            started = true;
            LanternNightSprite.createOrRemoveEmitter(player);
        } else {
            LanternNightSprite.reset();
        }
    }

    static void createOrRemoveEmitter(Player player) {
        if (player.level().dimension() == OverworldUtils.dimension()) {
            if (emitter != null) {
                emitter.remove();
            }
            emitter = new ParticleEmitter(player.level(), player.position(), Confluence.asResource("lantern_night")){

                protected void createVars() {
                    super.createVars();
                    Variable windX = new Variable("variable.wind_x", p -> WeatherHandler.getWindSpeedX());
                    Variable windZ = new Variable("variable.wind_z", p -> WeatherHandler.getWindSpeedZ());
                    this.vars.table.put(windX.name(), windX);
                    this.vars.table.put(windZ.name(), windZ);
                }
            };
            emitter.attachEntity((Entity)player);
            PSGameClient.LOADER.addEmitter(emitter, false);
        } else if (emitter != null) {
            emitter.remove();
            emitter = null;
        }
    }

    static void reset() {
        SPRITES.clear();
        started = false;
        globalAlpha = 0.0f;
        globalY = -90.0f;
        globalYO = -90.0f;
        if (emitter != null) {
            emitter.remove();
            emitter = null;
        }
    }
}

