/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gameevent;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.Confluence;

public class GoblinArmyProgressRenderer
implements LayeredDraw.Layer {
    static final ResourceLocation SPRITE = Confluence.asResource("hud/goblin_army");
    static final int IMAGE_WIDTH = 256;
    static final int IMAGE_HEIGHT = 96;
    static final int HALF_U_WIDTH = 128;
    static final int V_HEIGHT = 48;
    public static float yOffset;
    static boolean started;
    static float progressed;

    static void handleSync(Player player, boolean start) {
        started = start;
    }

    static void reset() {
        yOffset = 0.0f;
        started = false;
        progressed = 0.0f;
    }

    public static void handleProgress(float progress) {
        progressed = progress;
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!started) {
            return;
        }
        int centerX = guiGraphics.guiWidth() / 2;
        int x = centerX - 128;
        int y = Math.max(Mth.ceil((float)yOffset) - 16, 0);
        guiGraphics.blitSprite(SPRITE, 256, 96, 0, 0, x, y, 256, 48);
        int u = (int)(256.0f * progressed);
        guiGraphics.blitSprite(SPRITE, 256, 96, 0, 48, x, y, 256 - u, 48);
        yOffset = 0.0f;
    }
}

