/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.event;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.neoforged.neoforge.client.event.RegisterRenderBuffersEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.confluence.lib.client.render.item.SimpleClientItemExtensions;
import org.confluence.lib.common.item.ColoredItem;
import org.confluence.mod.Confluence;
import org.confluence.mod.StartupConfigs;
import org.confluence.mod.api.event.bestiary.RegisterCustomBestiaryEntryRendererEvent;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.client.effect.ColoredGlintContext;
import org.confluence.mod.client.effect.connected.CustomBlockModels;
import org.confluence.mod.client.effect.connected.ModConnectives;
import org.confluence.mod.client.effect.connected.ModelSwapper;
import org.confluence.mod.client.effect.connected.StitchedSprite;
import org.confluence.mod.client.effect.textures.GrayBlockModelSwapper;
import org.confluence.mod.client.effect.textures.GraySpriteShifterEntry;
import org.confluence.mod.client.event.ModClientSetups;
import org.confluence.mod.client.gameevent.GoblinArmyProgressRenderer;
import org.confluence.mod.client.gui.container.AlchemyTableScreen;
import org.confluence.mod.client.gui.container.CookingPotScreen;
import org.confluence.mod.client.gui.container.CrystalBallScreen;
import org.confluence.mod.client.gui.container.DyeMixScreen;
import org.confluence.mod.client.gui.container.DyeVatScreen;
import org.confluence.mod.client.gui.container.ExtraInventoryScreen;
import org.confluence.mod.client.gui.container.FletchingTableScreen;
import org.confluence.mod.client.gui.container.HardmodeAnvilScreen;
import org.confluence.mod.client.gui.container.HardmodeForgeScreen;
import org.confluence.mod.client.gui.container.HeavyWorkBenchScreen;
import org.confluence.mod.client.gui.container.HellforgeScreen;
import org.confluence.mod.client.gui.container.LoomScreen;
import org.confluence.mod.client.gui.container.NPCReforgeScreen;
import org.confluence.mod.client.gui.container.SawmillScreen;
import org.confluence.mod.client.gui.container.SkyMillScreen;
import org.confluence.mod.client.gui.container.SolidifierScreen;
import org.confluence.mod.client.gui.container.WithForgeTradeScreen;
import org.confluence.mod.client.gui.hud.HouseSelectHUD;
import org.confluence.mod.client.gui.hud.RepeaterHud;
import org.confluence.mod.client.gui.hud.TerraStyleArmorHud;
import org.confluence.mod.client.gui.hud.TerraStyleFoodHud;
import org.confluence.mod.client.gui.hud.TerraStyleHealthHud;
import org.confluence.mod.client.gui.hud.TerraStyleManaHud;
import org.confluence.mod.client.gui.hud.TerraStyleSoulHud;
import org.confluence.mod.client.handler.bestiary.ClientBestiary;
import org.confluence.mod.client.model.block.LifeCrystalBlockModel;
import org.confluence.mod.client.model.block.RelicBlockModel;
import org.confluence.mod.client.model.block.WeatherVaneBlockModel;
import org.confluence.mod.client.model.entity.bomb.BaseBombEntityModel;
import org.confluence.mod.client.model.entity.bomb.BaseDynamiteEntityModel;
import org.confluence.mod.client.model.entity.bomb.BaseGrenadeEntityModel;
import org.confluence.mod.client.model.entity.bomb.BeenadeEntityModel;
import org.confluence.mod.client.model.entity.bomb.BombFishEntityModel;
import org.confluence.mod.client.model.entity.bomb.BouncyBombEntityModel;
import org.confluence.mod.client.model.entity.bomb.BouncyDynamiteEntityModel;
import org.confluence.mod.client.model.entity.bomb.BouncyGrenadeEntityModel;
import org.confluence.mod.client.model.entity.bomb.DirtBombEntityModel;
import org.confluence.mod.client.model.entity.bomb.DryBombEntityModel;
import org.confluence.mod.client.model.entity.bomb.HoneyBombEntityModel;
import org.confluence.mod.client.model.entity.bomb.LavaBombEntityModel;
import org.confluence.mod.client.model.entity.bomb.ScarabBombEntityModel;
import org.confluence.mod.client.model.entity.bomb.StickyBombEntityModel;
import org.confluence.mod.client.model.entity.bomb.StickyDirtBombEntityModel;
import org.confluence.mod.client.model.entity.bomb.StickyDynamiteEntityModel;
import org.confluence.mod.client.model.entity.bomb.StickyGrenadeEntityModel;
import org.confluence.mod.client.model.entity.bomb.WetBombEntityModel;
import org.confluence.mod.client.model.entity.fishing.BaseFishingHookModel;
import org.confluence.mod.client.model.entity.fishing.BloodyFishingHookModel;
import org.confluence.mod.client.model.entity.fishing.GlowingFishingHookModel;
import org.confluence.mod.client.model.entity.fishing.HotlineFishingHookModel;
import org.confluence.mod.client.model.entity.hook.BaseHookModel;
import org.confluence.mod.client.model.entity.hook.SkeletronHandModel;
import org.confluence.mod.client.model.entity.hook.WebSlingerModel;
import org.confluence.mod.client.model.entity.projectile.BloodCloudProjectileModel;
import org.confluence.mod.client.model.entity.projectile.BoneThrownKnivesProjectileModel;
import org.confluence.mod.client.model.entity.projectile.DemonScytheProjectileModel;
import org.confluence.mod.client.model.entity.projectile.DungeonDemonBoneProjectileModel;
import org.confluence.mod.client.model.entity.projectile.EnchantedSwordProjectileModel;
import org.confluence.mod.client.model.entity.projectile.FlailModel;
import org.confluence.mod.client.model.entity.projectile.FrostDaggerfishProjectileModel;
import org.confluence.mod.client.model.entity.projectile.HurtnadoProjectileModel;
import org.confluence.mod.client.model.entity.projectile.IceBladeSwordProjectileModel;
import org.confluence.mod.client.model.entity.projectile.RainCloudProjectileModel;
import org.confluence.mod.client.model.entity.projectile.RainProjectileModel;
import org.confluence.mod.client.model.entity.projectile.RollingCactusSpikeModel;
import org.confluence.mod.client.model.entity.projectile.ShurikenProjectileModel;
import org.confluence.mod.client.model.entity.projectile.SkullProjectileModel;
import org.confluence.mod.client.model.entity.projectile.SpikyBallProjectileModel;
import org.confluence.mod.client.model.entity.projectile.StormSpearShotProjectileModel;
import org.confluence.mod.client.model.entity.projectile.ThrownKniveProjectileModel;
import org.confluence.mod.client.model.entity.projectile.TitaniumShardsProjectileModel;
import org.confluence.mod.client.model.entity.projectile.VilethronProjectileModel;
import org.confluence.mod.client.particle.BiomeColorParticle;
import org.confluence.mod.client.particle.DamageIndicatorParticle;
import org.confluence.mod.client.particle.EctoMistParticle;
import org.confluence.mod.client.particle.LightBaneParticle;
import org.confluence.mod.client.particle.SimpleTextureSheetParticle;
import org.confluence.mod.client.particle.WholeItemParticle;
import org.confluence.mod.client.renderer.block.AltarBlockRenderer;
import org.confluence.mod.client.renderer.block.BaseChestBlockRenderer;
import org.confluence.mod.client.renderer.block.BewitchingTableBlockRenderer;
import org.confluence.mod.client.renderer.block.DeathChestBlockRenderer;
import org.confluence.mod.client.renderer.block.ExtractinatorBlockRenderer;
import org.confluence.mod.client.renderer.block.IgnoreEnvironmentLightGeoBlockRenderer;
import org.confluence.mod.client.renderer.block.LoomBlockRenderer;
import org.confluence.mod.client.renderer.block.MechanicalBlockRenderer;
import org.confluence.mod.client.renderer.block.MuralBlockRenderer;
import org.confluence.mod.client.renderer.block.SkyMillBlockRenderer;
import org.confluence.mod.client.renderer.block.SoulBottleBlockRenderer;
import org.confluence.mod.client.renderer.block.TuffBoothBlockRenderer;
import org.confluence.mod.client.renderer.block.WeatherVaneBlockRenderer;
import org.confluence.mod.client.renderer.entity.BodyPartRenderer;
import org.confluence.mod.client.renderer.entity.EmptyEntityRenderer;
import org.confluence.mod.client.renderer.entity.FallingStarRenderer;
import org.confluence.mod.client.renderer.entity.TreasureBagRenderer;
import org.confluence.mod.client.renderer.entity.bestiary.BestiaryEntryDisplayRenderer;
import org.confluence.mod.client.renderer.entity.bestiary.SlimeZombieRenderer;
import org.confluence.mod.client.renderer.entity.fishing.BaseFishingHookRenderer;
import org.confluence.mod.client.renderer.entity.fishing.BloodyFishingHookRenderer;
import org.confluence.mod.client.renderer.entity.fishing.GlowingFishingHookRenderer;
import org.confluence.mod.client.renderer.entity.fishing.HotlineFishingHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.AntiGravityHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.BaseHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.BatHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.CandyCaneHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.ChristmasHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.DualHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.FishHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.HookOfDissonanceRenderer;
import org.confluence.mod.client.renderer.entity.hook.IvyWhipRenderer;
import org.confluence.mod.client.renderer.entity.hook.LunarHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.MimicHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.SkeletronHandRenderer;
import org.confluence.mod.client.renderer.entity.hook.SlimeHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.SpookyHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.ThornHookRenderer;
import org.confluence.mod.client.renderer.entity.hook.WebSlingerRenderer;
import org.confluence.mod.client.renderer.entity.projectile.BoneThrownKniveProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.BoulderRenderer;
import org.confluence.mod.client.renderer.entity.projectile.DemonScytheProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.DungeonDemonBoneProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.FlailRenderer;
import org.confluence.mod.client.renderer.entity.projectile.FrostDaggerfishProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.GeoArrowRenderer;
import org.confluence.mod.client.renderer.entity.projectile.HurtnadoProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.RainProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.RollingCactusSpikeRenderer;
import org.confluence.mod.client.renderer.entity.projectile.ShurikenProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.SkullProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.SpearRenderer;
import org.confluence.mod.client.renderer.entity.projectile.SpikyBallProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.StarCannonBulletRenderer;
import org.confluence.mod.client.renderer.entity.projectile.StormSpearShotProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.SuperSpikyBallProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.TerraArrowRenderer;
import org.confluence.mod.client.renderer.entity.projectile.ThrownKniveProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.TitaniumShardsProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.VilethronProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.BaseBombEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.BaseDynamiteEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.BaseGrenadeEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.BeenadeEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.BombFishEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.BouncyBombEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.BouncyDynamiteEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.BouncyGrenadeEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.DirtBombEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.DryBombEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.HoneyBombEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.LavaBombEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.ScarabBombEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.StickyBombEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.StickyDirtBombEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.StickyDynamiteEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.StickyGrenadeEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.bomb.WetBombEntityRenderer;
import org.confluence.mod.client.renderer.entity.projectile.sword.ForwardProjRenderer;
import org.confluence.mod.client.renderer.entity.projectile.sword.LightsBaneProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.sword.NightEdgeProjectileRenderer;
import org.confluence.mod.client.renderer.entity.projectile.sword.StarFuryProjectileRenderer;
import org.confluence.mod.client.renderer.item.ArrowInBowRenderer;
import org.confluence.mod.client.renderer.item.GroupItemExtension;
import org.confluence.mod.client.renderer.item.LucyTheAxeDialogRenderer;
import org.confluence.mod.client.renderer.item.ShortSwordInHandRenderer;
import org.confluence.mod.client.renderer.tooltip.AltImageTooltip;
import org.confluence.mod.client.renderer.tooltip.ClientRepeaterContentsTooltip;
import org.confluence.mod.client.renderer.tooltip.NoopTooltip;
import org.confluence.mod.common.block.common.RelicBlock;
import org.confluence.mod.common.data.LucyTheAxeDialogCategory;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModFluids;
import org.confluence.mod.common.init.ModMenuTypes;
import org.confluence.mod.common.init.ModParticleTypes;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.block.StatueBlocks;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.AxeItems;
import org.confluence.mod.common.init.item.ChainsawItems;
import org.confluence.mod.common.init.item.CrossbowItems;
import org.confluence.mod.common.init.item.DrillItems;
import org.confluence.mod.common.init.item.FishingPoleItems;
import org.confluence.mod.common.init.item.GunItems;
import org.confluence.mod.common.init.item.LanceItems;
import org.confluence.mod.common.init.item.ManaWeaponItems;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.init.item.PaintItems;
import org.confluence.mod.common.init.item.SpearItems;
import org.confluence.mod.common.init.item.SwordItems;
import org.confluence.mod.common.init.item.TreasureBagItems;
import org.confluence.mod.common.init.item.VanityArmorItems;
import org.confluence.mod.common.item.GroupItem;
import org.confluence.mod.common.item.common.BaseDyeItem;
import org.confluence.mod.common.item.crossbow.BaseTerraRepeaterItem;
import org.confluence.mod.common.item.paint.PaintItem;
import org.confluence.mod.common.item.tooltipcomponent.AltImageComponent;
import org.confluence.mod.common.item.tooltipcomponent.RepeaterComponent;
import org.confluence.mod.integration.appleskin.AppleskinHelper;
import org.confluence.mod.integration.create.ponder.PonderHelper;
import org.confluence.mod.integration.prism_lib.PrismLibHelper;
import org.confluence.mod.integration.sodium.dynamiclights.SodiumDynamicLightsHelper;
import org.confluence.mod.util.ClientUtils;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.model.entity.BeeProjectileModel;
import org.confluence.terra_guns.util.TGUtil;
import org.confluence.terraentity.client.entity.renderer.mob.GeoNegativeVolumeRenderer;
import org.confluence.terraentity.init.entity.TEMonsterEntities;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

@EventBusSubscriber(value={Dist.CLIENT}, modid="confluence")
public final class ModClientEvents {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientConfigs.onLoad();
            ModClientSetups.registerBowProperties();
            ModClientSetups.registerFishingPoleProperties();
            ArrowInBowRenderer.initAdaptionMap();
            ModClientSetups.registerItemProperties();
            ModClientSetups.setRenderLayers();
            PonderHelper.registerPlugin();
            AppleskinHelper.addListeners();
            SodiumDynamicLightsHelper.registerDynamicLight();
            ClientBestiary.getInstance().registerCustomFilter();
        });
    }

    @SubscribeEvent
    public static void modConfig$Reloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getModId().equals("confluence")) {
            ClientConfigs.onLoad();
        }
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(ModMenuTypes.SKY_MILL.get(), SkyMillScreen::new);
        event.register(ModMenuTypes.HEAVY_WORK_BENCH.get(), HeavyWorkBenchScreen::new);
        event.register(ModMenuTypes.HELLFORGE.get(), HellforgeScreen::new);
        event.register(ModMenuTypes.FLETCHING_TABLE.get(), FletchingTableScreen::new);
        event.register(ModMenuTypes.ALCHEMY_TABLE.get(), AlchemyTableScreen::new);
        event.register(ModMenuTypes.EXTRA_INVENTORY.get(), ExtraInventoryScreen::new);
        event.register(ModMenuTypes.COOKING_POT.get(), CookingPotScreen::new);
        event.register(ModMenuTypes.SAWMILL.get(), SawmillScreen::new);
        event.register(ModMenuTypes.SOLIDIFIER.get(), SolidifierScreen::new);
        event.register(ModMenuTypes.CRYSTAL_BALL.get(), CrystalBallScreen::new);
        event.register(ModMenuTypes.HARDMODE_ANVIL.get(), HardmodeAnvilScreen::new);
        event.register(ModMenuTypes.HARDMODE_FORGE.get(), HardmodeForgeScreen::new);
        event.register(ModMenuTypes.LOOM.get(), LoomScreen::new);
        event.register(ModMenuTypes.DYE_VAT.get(), DyeVatScreen::new);
        event.register(ModMenuTypes.DYE_MIX.get(), DyeMixScreen::new);
        event.register(ModMenuTypes.NPC_TRADES_MENU.get(), WithForgeTradeScreen::new);
        event.register(ModMenuTypes.REFORGE_MENU.get(), NPCReforgeScreen::new);
    }

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        ResourceLocation repeaterHud = Confluence.asResource("repeater_hud");
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, repeaterHud, (LayeredDraw.Layer)new RepeaterHud());
        ResourceLocation healthHud = Confluence.asResource("health_hud");
        event.registerBelow(VanillaGuiLayers.ARMOR_LEVEL, healthHud, (LayeredDraw.Layer)new TerraStyleHealthHud());
        ResourceLocation armorHud = Confluence.asResource("armor_hud");
        event.registerAbove(healthHud, armorHud, (LayeredDraw.Layer)new TerraStyleArmorHud());
        ResourceLocation manaHud = Confluence.asResource("mana_hud");
        event.registerAbove(VanillaGuiLayers.FOOD_LEVEL, manaHud, (LayeredDraw.Layer)new TerraStyleManaHud());
        ResourceLocation soulHud = Confluence.asResource("soul_hud");
        event.registerAbove(VanillaGuiLayers.FOOD_LEVEL, soulHud, (LayeredDraw.Layer)new TerraStyleSoulHud());
        ResourceLocation foodHud = Confluence.asResource("food_hud");
        event.registerBelow(soulHud, foodHud, (LayeredDraw.Layer)new TerraStyleFoodHud());
        event.registerBelow(VanillaGuiLayers.CROSSHAIR, Confluence.asResource("house_select"), (LayeredDraw.Layer)new HouseSelectHUD());
        event.registerBelow(VanillaGuiLayers.BOSS_OVERLAY, Confluence.asResource("goblin_army"), (LayeredDraw.Layer)new GoblinArmyProgressRenderer());
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BaseBombEntityModel.LAYER_LOCATION, BaseBombEntityModel::createBodyLayer);
        event.registerLayerDefinition(BouncyBombEntityModel.LAYER_LOCATION, BouncyBombEntityModel::createBodyLayer);
        event.registerLayerDefinition(ScarabBombEntityModel.LAYER_LOCATION, ScarabBombEntityModel::createBodyLayer);
        event.registerLayerDefinition(StickyBombEntityModel.LAYER_LOCATION, StickyBombEntityModel::createBodyLayer);
        event.registerLayerDefinition(BombFishEntityModel.LAYER_LOCATION, BombFishEntityModel::createBodyLayer);
        event.registerLayerDefinition(DirtBombEntityModel.LAYER_LOCATION, DirtBombEntityModel::createBodyLayer);
        event.registerLayerDefinition(StickyDirtBombEntityModel.LAYER_LOCATION, StickyDirtBombEntityModel::createBodyLayer);
        event.registerLayerDefinition(BaseDynamiteEntityModel.LAYER_LOCATION, BaseDynamiteEntityModel::createBodyLayer);
        event.registerLayerDefinition(StickyDynamiteEntityModel.LAYER_LOCATION, StickyDynamiteEntityModel::createBodyLayer);
        event.registerLayerDefinition(BouncyDynamiteEntityModel.LAYER_LOCATION, BouncyDynamiteEntityModel::createBodyLayer);
        event.registerLayerDefinition(BaseGrenadeEntityModel.LAYER_LOCATION, BaseGrenadeEntityModel::createBodyLayer);
        event.registerLayerDefinition(DryBombEntityModel.LAYER_LOCATION, DryBombEntityModel::createBodyLayer);
        event.registerLayerDefinition(WetBombEntityModel.LAYER_LOCATION, WetBombEntityModel::createBodyLayer);
        event.registerLayerDefinition(LavaBombEntityModel.LAYER_LOCATION, LavaBombEntityModel::createBodyLayer);
        event.registerLayerDefinition(HoneyBombEntityModel.LAYER_LOCATION, HoneyBombEntityModel::createBodyLayer);
        event.registerLayerDefinition(StickyGrenadeEntityModel.LAYER_LOCATION, StickyGrenadeEntityModel::createBodyLayer);
        event.registerLayerDefinition(BouncyGrenadeEntityModel.LAYER_LOCATION, BouncyGrenadeEntityModel::createBodyLayer);
        event.registerLayerDefinition(BeenadeEntityModel.LAYER_LOCATION, BeenadeEntityModel::createBodyLayer);
        event.registerLayerDefinition(TitaniumShardsProjectileModel.LAYER_LOCATION, TitaniumShardsProjectileModel::createBodyLayer);
        event.registerLayerDefinition(BaseFishingHookModel.WOOD, BaseFishingHookModel::createWoodLayer);
        event.registerLayerDefinition(BaseFishingHookModel.REINFORCED, BaseFishingHookModel::createReinforcedLayer);
        event.registerLayerDefinition(BaseFishingHookModel.FISHER_OF_SOULS, BaseFishingHookModel::createFisherOfSoulsLayer);
        event.registerLayerDefinition(BaseFishingHookModel.FLESHCATCHER, BaseFishingHookModel::createFleshcatcherLayer);
        event.registerLayerDefinition(BaseFishingHookModel.SCARAB, BaseFishingHookModel::createScarabLayer);
        event.registerLayerDefinition(BloodyFishingHookModel.LAYER_LOCATION, BloodyFishingHookModel::createBodyLayer);
        event.registerLayerDefinition(BaseFishingHookModel.FIBERGLASS, BaseFishingHookModel::createFiberglassLayer);
        event.registerLayerDefinition(BaseFishingHookModel.MECHANICS, BaseFishingHookModel::createMechanicsLayer);
        event.registerLayerDefinition(BaseFishingHookModel.SITTING_DUCKS, BaseFishingHookModel::createSittingDucksLayer);
        event.registerLayerDefinition(HotlineFishingHookModel.LAYER_LOCATION, HotlineFishingHookModel::createBodyLayer);
        event.registerLayerDefinition(BaseFishingHookModel.GOLDEN, BaseFishingHookModel::createGoldenLayer);
        event.registerLayerDefinition(GlowingFishingHookModel.MOSS, GlowingFishingHookModel::createMossLayer);
        event.registerLayerDefinition(GlowingFishingHookModel.COMMON, GlowingFishingHookModel::createCommonLayer);
        event.registerLayerDefinition(GlowingFishingHookModel.GLOWING, GlowingFishingHookModel::createGlowingLayer);
        event.registerLayerDefinition(IceBladeSwordProjectileModel.LAYER_LOCATION, IceBladeSwordProjectileModel::createBodyLayer);
        event.registerLayerDefinition(EnchantedSwordProjectileModel.LAYER_LOCATION, EnchantedSwordProjectileModel::createBodyLayer);
        event.registerLayerDefinition(ShurikenProjectileModel.LAYER_LOCATION, ShurikenProjectileModel::createBodyLayer);
        event.registerLayerDefinition(ThrownKniveProjectileModel.LAYER_LOCATION, ThrownKniveProjectileModel::createBodyLayer);
        event.registerLayerDefinition(BoneThrownKnivesProjectileModel.LAYER_LOCATION, BoneThrownKnivesProjectileModel::createBodyLayer);
        event.registerLayerDefinition(DungeonDemonBoneProjectileModel.LAYER_LOCATION, DungeonDemonBoneProjectileModel::createBodyLayer);
        event.registerLayerDefinition(FrostDaggerfishProjectileModel.LAYER_LOCATION, FrostDaggerfishProjectileModel::createBodyLayer);
        event.registerLayerDefinition(VilethronProjectileModel.LAYER_LOCATION, VilethronProjectileModel::createBodyLayer);
        event.registerLayerDefinition(DemonScytheProjectileModel.LAYER_LOCATION, DemonScytheProjectileModel::createBodyLayer);
        event.registerLayerDefinition(SpikyBallProjectileModel.LAYER_LOCATION, SpikyBallProjectileModel::createBodyLayer);
        event.registerLayerDefinition(HurtnadoProjectileModel.LAYER_LOCATION, HurtnadoProjectileModel::createBodyLayer);
        event.registerLayerDefinition(RollingCactusSpikeModel.LAYER_LOCATION, RollingCactusSpikeModel::createBodyLayer);
        event.registerLayerDefinition(RainProjectileModel.LAYER_LOCATION, RainProjectileModel::createBodyLayer);
        event.registerLayerDefinition(SkullProjectileModel.LAYER_LOCATION, SkullProjectileModel::createBodyLayer);
        event.registerLayerDefinition(StormSpearShotProjectileModel.LAYER_LOCATION, StormSpearShotProjectileModel::createBodyLayer);
        event.registerLayerDefinition(BaseHookModel.LAYER_LOCATION, BaseHookModel::createBodyLayer);
        event.registerLayerDefinition(WebSlingerModel.LAYER_LOCATION, WebSlingerModel::createBodyLayer);
        event.registerLayerDefinition(SkeletronHandModel.LAYER_LOCATION, SkeletronHandModel::createBodyLayer);
        event.registerLayerDefinition(FlailModel.LAYER_LOCATION, FlailModel::createBodyLayer);
        event.registerLayerDefinition(WeatherVaneBlockModel.LAYER_LOCATION, WeatherVaneBlockModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntities.EMPTY_ENTITY.get(), EmptyEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BOMB_ENTITY.get(), BaseBombEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BOUNCY_BOMB_ENTITY.get(), BouncyBombEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SCARAB_BOMB_ENTITY.get(), ScarabBombEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STICKY_BOMB_ENTITY.get(), StickyBombEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SMOKE_BOMB_ENTITY.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BOMB_FISH_ENTITY.get(), BombFishEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.DIRT_BOMB.get(), DirtBombEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STICKY_DIRT_BOMB.get(), StickyDirtBombEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.GRENADE.get(), BaseGrenadeEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BOUNCY_GRENADE.get(), BouncyGrenadeEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STICKY_GRENADE.get(), StickyGrenadeEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BEENADE.get(), BeenadeEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.DYNAMITE.get(), BaseDynamiteEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BOUNCY_DYNAMITE.get(), BouncyDynamiteEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STICKY_DYNAMITE.get(), StickyDynamiteEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.DRY_BOMB.get(), DryBombEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WET_BOMB.get(), WetBombEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.LAVA_BOMB.get(), LavaBombEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.HONEY_BOMB.get(), HoneyBombEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BASE_MANA_STAFF_PROJECTILE.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.VILETHRON_PROJECTILE.get(), VilethronProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.HURTNADO_PROJECTILE.get(), HurtnadoProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WATER_STREAM_PROJECTILE.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WATER_BOLT_PROJECTILE.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BALL_OF_FIRE_PROJECTILE.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.EFFECT_THROWN_POTION.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ICE_BLADE_SWORD_PROJECTILE.get(), context -> new ForwardProjRenderer(context, new IceBladeSwordProjectileModel(context.bakeLayer(IceBladeSwordProjectileModel.LAYER_LOCATION)), Confluence.asResource("textures/entity/ice_blade_sword_projectile.png"), 1.0f, 0.0f));
        event.registerEntityRenderer((EntityType)ModEntities.STAR_FURY_PROJECTILE.get(), StarFuryProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENCHANTED_SWORD_PROJECTILE.get(), context -> new ForwardProjRenderer(context, new EnchantedSwordProjectileModel(context.bakeLayer(EnchantedSwordProjectileModel.LAYER_LOCATION)), Confluence.asResource("textures/entity/enchanted_sword_projectile.png"), 1.0f, 0.2f, 0.89f));
        event.registerEntityRenderer((EntityType)ModEntities.LIGHTS_BANE_PROJECTILE.get(), LightsBaneProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.GRASS_PROJECTILE.get(), context -> new ForwardProjRenderer(context, null, null));
        event.registerEntityRenderer((EntityType)ModEntities.BEE_PROJECTILE.get(), context -> new ForwardProjRenderer(context, new BeeProjectileModel(context.bakeLayer(BeeProjectileModel.LAYER_LOCATION)), TerraCurio.asResource((String)"textures/entity/bee_projectile.png")));
        event.registerEntityRenderer((EntityType)ModEntities.NIGHTS_EDGE_PROJECTILE.get(), NightEdgeProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ARROW_PROJECTILE.get(), TerraArrowRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BEE_ARROW.get(), context -> new ForwardProjRenderer(context, new BeeProjectileModel(context.bakeLayer(BeeProjectileModel.LAYER_LOCATION)), TerraCurio.asResource((String)"textures/entity/bee_projectile.png")));
        event.registerEntityRenderer((EntityType)ModEntities.HELL_BAT_ARROW.get(), context -> new GeoArrowRenderer(context, TEMonsterEntities.HELL_BAT.getId(), 0.5f, 0.0f));
        event.registerEntityRenderer((EntityType)ModEntities.BOULDER.get(), BoulderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FOLLOWER_BOULDER.get(), BoulderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.EXPLODE_BOULDER.get(), BoulderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ROLLING_CACTUS_BOULDER.get(), BoulderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ROLLING_CACTUS_SPIKE.get(), RollingCactusSpikeRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.TOMBSTONE_BOULDER.get(), BoulderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BOULDER_3X.get(), BoulderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.THROWN_KNIVE_PROJECTILE.get(), ThrownKniveProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BONE_THROWN_KNIVE_PROJECTILE.get(), BoneThrownKniveProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FROST_DAGGERFISH_PROJECTILE.get(), FrostDaggerfishProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.DUNGEON_DEMON_BONE_PROJECTILE.get(), DungeonDemonBoneProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.JAVELIN_PROJECTILE.get(), SpearRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SHURIKEN_PROJECTILE.get(), ShurikenProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SPIKY_BALL_PROJECTILE.get(), SpikyBallProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.THROWN_WATER_PROJECTILE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.MAGIC_DAGGER_PROJECTILE.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.CRYSTAL_STORM_PROJECTILE.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.CURSED_FLAMES_PROJECTILE.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FLOWER_PETAL_PROJECTILE.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.TITANIUM_SHARDS_PROJECTILE.get(), TitaniumShardsProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FALLING_STAR_ITEM_ENTITY.get(), FallingStarRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.TREASURE_BAG_ITEM_ENTITY.get(), TreasureBagRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.COIN_PORTAL.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.THROWN_POWDER.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ROPE_COILS.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ICE_TOFU_BRICK_PROJECTILE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BODY_PART.get(), BodyPartRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FLAME_CLOUD.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SUPER_SPIKY_BALL_PROJECTILE.get(), SuperSpikyBallProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SPEAR.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BALL_OF_FROST_PROJECTILE.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.DEMON_SCYTHE_PROJECTILE.get(), DemonScytheProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SKULL_PROJECTILE.get(), SkullProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BLOOD_CLOUD_PROJECTILE.get(), context -> new GeoNegativeVolumeRenderer(context, (GeoModel)new BloodCloudProjectileModel(), false, 2.0f, -0.2f));
        event.registerEntityRenderer((EntityType)ModEntities.BLOOD_RAIN_PROJECTILE.get(), context -> new RainProjectileRenderer(context, RainProjectileRenderer.BLOOD_RAIN));
        event.registerEntityRenderer((EntityType)ModEntities.RAIN_CLOUD_PROJECTILE.get(), context -> new GeoNegativeVolumeRenderer(context, (GeoModel)new RainCloudProjectileModel(), false, 2.0f, -0.2f));
        event.registerEntityRenderer((EntityType)ModEntities.RAIN_PROJECTILE.get(), context -> new RainProjectileRenderer(context, RainProjectileRenderer.RAIN));
        event.registerEntityRenderer((EntityType)ModEntities.STORM_SPEAR_SHOT_PROJECTILE.get(), StormSpearShotProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.GOLDEN_SHOWER_PROJECTILE.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.HOTLINE_FISHING_HOOK.get(), HotlineFishingHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BASE_FISHING_HOOK.get(), BaseFishingHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BLOODY_FISHING_HOOK.get(), BloodyFishingHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.CURIO_FISHING_HOOK.get(), GlowingFishingHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BASE_HOOK.get(), BaseHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WEB_SLINGER.get(), WebSlingerRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SKELETRON_HAND.get(), SkeletronHandRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SLIME_HOOK.get(), SlimeHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FISH_HOOK.get(), FishHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.IVY_WHIP.get(), IvyWhipRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.BAT_HOOK.get(), BatHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.CANDY_CANE_HOOK.get(), CandyCaneHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.DUAL_HOOK.get(), DualHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.HOOK_OF_DISSONANCE.get(), HookOfDissonanceRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.THORN_HOOK.get(), ThornHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.MIMIC_HOOK.get(), MimicHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ANTI_GRAVITY_HOOK.get(), AntiGravityHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SPOOKY_HOOK.get(), SpookyHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.CHRISTMAS_HOOK.get(), ChristmasHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.LUNAR_HOOK.get(), LunarHookRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FLAIL_BALL.get(), FlailRenderer::new);
        EntityRendererProvider provider = context -> new MinecartRenderer(context, ModelLayers.MINECART);
        event.registerEntityRenderer((EntityType)ModEntities.VANILLA_MINECART.get(), provider);
        event.registerEntityRenderer((EntityType)ModEntities.WOODEN_MINECART.get(), provider);
        event.registerEntityRenderer((EntityType)ModEntities.GENERIC_MINECART.get(), provider);
        event.registerEntityRenderer((EntityType)ModEntities.MECHANICAL_CART.get(), provider);
        event.registerEntityRenderer((EntityType)ModEntities.MINECARP.get(), provider);
        event.registerEntityRenderer((EntityType)ModEntities.DEMONIC_HELLCART.get(), provider);
        event.registerEntityRenderer((EntityType)ModEntities.MEOWMERE_MINECART.get(), provider);
        event.registerEntityRenderer((EntityType)ModEntities.DIGGING_MOLECART.get(), provider);
        event.registerEntityRenderer((EntityType)ModEntities.BESTIARY_ENTRY_DISPLAY.get(), BestiaryEntryDisplayRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STAR_CANNON_BULLET.get(), StarCannonBulletRenderer::new);
        event.registerBlockEntityRenderer(FunctionalBlocks.ALTAR_BLOCK_ENTITY.get(), AltarBlockRenderer::new);
        event.registerBlockEntityRenderer(FunctionalBlocks.SKY_MILL_ENTITY.get(), ClientUtils.rendererProvider(SkyMillBlockRenderer::new));
        event.registerBlockEntityRenderer(FunctionalBlocks.EXTRACTINATOR_ENTITY.get(), ClientUtils.rendererProvider(ExtractinatorBlockRenderer::new));
        event.registerBlockEntityRenderer(FunctionalBlocks.MECHANICAL_BLOCK_ENTITY.get(), ClientUtils.rendererProvider(MechanicalBlockRenderer::new));
        event.registerBlockEntityRenderer(FunctionalBlocks.SILLY_BALLOON_MACHINE_ENTITY.get(), ClientUtils.rendererProvider(MechanicalBlockRenderer::new));
        event.registerBlockEntityRenderer(FunctionalBlocks.WEATHER_VANE_ENTITY.get(), WeatherVaneBlockRenderer::new);
        event.registerBlockEntityRenderer(ChestBlocks.BASE_CHEST_ENTITY.get(), BaseChestBlockRenderer::new);
        event.registerBlockEntityRenderer(ChestBlocks.DEATH_CHEST_ENTITY.get(), DeathChestBlockRenderer::new);
        event.registerBlockEntityRenderer(NatureBlocks.LIFE_CRYSTAL_BLOCK_ENTITY.get(), context -> new GeoBlockRenderer((GeoModel)new LifeCrystalBlockModel()));
        event.registerBlockEntityRenderer(DecorativeBlocks.RELIC_ENTITY.get(), context -> new IgnoreEnvironmentLightGeoBlockRenderer<RelicBlock.BEntity>(new RelicBlockModel()));
        event.registerBlockEntityRenderer(StatueBlocks.BLOCK_ENTITY.get(), ClientUtils.rendererProvider(MechanicalBlockRenderer::new));
        event.registerBlockEntityRenderer(FunctionalBlocks.COOKING_POT_ENTITY.get(), context -> new GeoBlockRenderer((GeoModel)new DefaultedBlockGeoModel(Confluence.asResource("cooking_pot"))));
        event.registerBlockEntityRenderer(FunctionalBlocks.ANNOUNCEMENT_BOX_ENTITY.get(), SignRenderer::new);
        event.registerBlockEntityRenderer(FunctionalBlocks.SAFE_ENTITY.get(), context -> new GeoBlockRenderer((GeoModel)new DefaultedBlockGeoModel(Confluence.asResource("safe"))));
        event.registerBlockEntityRenderer(DecorativeBlocks.MURAL_ENTITY_BLOCK.get(), ClientUtils.rendererProvider(MuralBlockRenderer::new));
        event.registerBlockEntityRenderer(FunctionalBlocks.BEWITCHING_TABLE_ENTITY.get(), ClientUtils.rendererProvider(BewitchingTableBlockRenderer::new));
        event.registerBlockEntityRenderer(FunctionalBlocks.LOOM_ENTITY.get(), ClientUtils.rendererProvider(LoomBlockRenderer::new));
        event.registerBlockEntityRenderer(FunctionalBlocks.SOUL_BOTTLE_ENTITY.get(), ClientUtils.rendererProvider(SoulBottleBlockRenderer::new));
        event.registerBlockEntityRenderer(FunctionalBlocks.TUFF_BOOTH_ENTITY.get(), ClientUtils.rendererProvider(TuffBoothBlockRenderer::new));
        ModClientSetups.registerWaystoneRenderers(event);
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register(ModClientSetups.HALLOW_LEAVES_COLOR, new Block[]{(Block)NatureBlocks.PEARL_LOG_BLOCKS.LEAVES.get()});
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.getDefaultColor(), new Block[]{(Block)NatureBlocks.BAOBAB_LOG_BLOCKS.LEAVES.get()});
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.getDefaultColor(), new Block[]{(Block)NatureBlocks.JUNGLE_GRASS_BLOCK.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((pStack, pTintIndex) -> ColoredItem.getRGBA((ItemStack)pStack), new ItemLike[]{(ItemLike)MaterialItems.GEL.get()});
        event.register((pStack, pTintIndex) -> GrassColor.getDefaultColor(), new ItemLike[]{(ItemLike)NatureBlocks.JUNGLE_GRASS_BLOCK.get()});
        event.register((stack, tintIndex) -> tintIndex == 1 ? PaintItem.getARGB(stack) : -1, (ItemLike[])PaintItems.PAINT_ITEMS.toArray(new Item[0]));
        event.register((stack, tintIndex) -> tintIndex == 1 ? BaseDyeItem.getARGB(stack) : -1, (ItemLike[])VanityArmorItems.COLORED_DYE_ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(ModClientSetups.HONEY_CLIENT_EXTENSIONS, new Holder[]{ModFluids.HONEY.type()});
        event.registerFluidType(ModClientSetups.SHIMMER_CLIENT_EXTENSIONS, new Holder[]{ModFluids.SHIMMER.type()});
        event.registerBlock(ModClientSetups.NO_HIT_EFFECTS, new Block[]{(Block)ModBlocks.ROPE.get(), (Block)ModBlocks.VINE_ROPE.get(), (Block)ModBlocks.SILK_ROPE.get(), (Block)ModBlocks.WEB_ROPE.get()});
        event.registerItem(ModClientSetups.ENTITY_DISPLAY, new Item[]{(Item)ModItems.ENTITY_DISPLAY.get()});
        event.registerItem((IClientItemExtensions)new SimpleClientItemExtensions().customRenderer((minecraft, stack, displayContext, poseStack, buffer, packedLight, packedOverlay) -> {
            SimpleClientItemExtensions.renderSimpleItem((Minecraft)minecraft, (ItemStack)stack, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (int)packedOverlay);
            if (LucyTheAxeDialogRenderer.dialog != null && displayContext == ItemDisplayContext.GUI) {
                LucyTheAxeDialogRenderer.renderInGui(minecraft, poseStack);
            }
        }), new Item[]{(Item)AxeItems.LUCY_THE_AXE.get()});
        event.registerItem(ModClientSetups.BREATHING_REED, new Holder[]{SwordItems.BREATHING_REED});
        event.registerItem(ModClientSetups.SPEAR, (Item[])SpearItems.ITEMS.getEntries().stream().map(DeferredHolder::get).toArray(Item[]::new));
        event.registerItem(ModClientSetups.UMBRELLA, new Holder[]{SwordItems.UMBRELLA, SwordItems.TRAGIC_UMBRELLA});
        event.registerItem(ModClientSetups.DRILL_O_CHAINSAW, (Item[])Streams.stream((Iterable)Iterables.concat((Iterable)DrillItems.ITEMS.getEntries(), (Iterable)ChainsawItems.ITEMS.getEntries())).filter(Objects::nonNull).map(DeferredHolder::get).toArray(Item[]::new));
        event.registerItem(ModClientSetups.LANCE, (Item[])LanceItems.ITEMS.getEntries().stream().map(DeferredHolder::get).toArray(Item[]::new));
        for (DeferredHolder holder2 : SwordItems.ITEMS.getEntries()) {
            if (!SwordItems.isShortSword((DeferredHolder<Item, ? extends Item>)holder2)) continue;
            event.registerItem((IClientItemExtensions)ShortSwordInHandRenderer.INSTANCE, new Item[]{(Item)holder2.get()});
        }
        event.registerItem(ModClientSetups.NOOP_ITEM, new Holder[]{SwordItems.ZOMBIE_ARM});
        event.registerItem(ModClientSetups.GUIDE_VOODOO_DOLL, new Holder[]{AccessoryItems.GUIDE_VOODOO_DOLL});
        event.registerItem(ModClientSetups.FULL_LIGHT, new Holder[]{MaterialItems.SOUL_OF_FRIGHT});
        event.registerItem(ModClientSetups.FULL_LIGHT, new Holder[]{MaterialItems.SOUL_OF_MIGHT});
        event.registerItem(ModClientSetups.FULL_LIGHT, new Holder[]{MaterialItems.SOUL_OF_SIGHT});
        event.registerItem(ModClientSetups.FULL_LIGHT, new Holder[]{MaterialItems.SOUL_OF_LIGHT});
        event.registerItem(ModClientSetups.FULL_LIGHT, new Holder[]{MaterialItems.SOUL_OF_NIGHT});
        event.registerItem(ModClientSetups.FULL_LIGHT, new Holder[]{MaterialItems.SOUL_OF_FLIGHT});
        event.registerItem(ModClientSetups.FULL_LIGHT, new Holder[]{MaterialItems.SOUL_OF_VOIGHT});
        event.registerItem(ModClientSetups.FULL_LIGHT, new Holder[]{MaterialItems.SOUL_OF_BRIGHT});
        if (GroupItem.enable) {
            event.registerItem((IClientItemExtensions)GroupItemExtension.INSTANCE, new Item[]{GroupItem.getInstance()});
        }
        event.registerItem(ModClientSetups.GLINT_RAINBOW_EXTENSIONS, (Item[])TreasureBagItems.ITEMS.getEntries().stream().map(DeferredHolder::get).toArray(Item[]::new));
        TGUtil.registerOtherGunModel((RegisterClientExtensionsEvent)event, (String)"confluence", ManaWeaponItems.BEE_GUN);
        TGUtil.registerOtherGunModel((RegisterClientExtensionsEvent)event, (String)"confluence", ManaWeaponItems.SPACE_GUN);
        GunItems.ITEMS.getEntries().forEach(holder -> TGUtil.registerOtherGunModel((RegisterClientExtensionsEvent)event, (String)"confluence", (DeferredHolder)holder));
        event.registerMobEffect(ModClientSetups.TRANSLUCENT_EFFECT_ICON, new MobEffect[]{(MobEffect)ModEffects.LUCK_EFFECT.get()});
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpecial(ModParticleTypes.DAMAGE_INDICATOR.get(), (ParticleProvider)new DamageIndicatorParticle.Provider());
        event.registerSpecial(ModParticleTypes.WHOLE_ITEM.get(), (ParticleProvider)new WholeItemParticle.Provider());
        event.registerSpriteSet((ParticleType)ModParticleTypes.LEAVES.get(), BiomeColorParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.RED_SAND.get(), SimpleTextureSheetParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.SAND.get(), SimpleTextureSheetParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.SNOW.get(), SimpleTextureSheetParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.YELLOW_WILLOW.get(), SimpleTextureSheetParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.LIGHT_BANE.get(), LightBaneParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.LIGHT_BANE_DUST.get(), SimpleTextureSheetParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.LIGHT_BANE_FADE.get(), SimpleTextureSheetParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.ECTO_MIST.get(), EctoMistParticle.Provider::new);
    }

    @SubscribeEvent
    public static void textureAtlasStitched(TextureAtlasStitchedEvent event) {
        TextureAtlas atlas = event.getAtlas();
        StitchedSprite.onTextureStitchPost(atlas);
        if (InventoryMenu.BLOCK_ATLAS.equals((Object)atlas.location())) {
            Map textures = atlas.getTextures();
            for (ResourceLocation key : ClientUtils.ORIGINAL) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)textures.get(key);
                TextureAtlasSprite gray = (TextureAtlasSprite)textures.get(key.withSuffix(".gray"));
                TextureAtlasSprite negative = (TextureAtlasSprite)textures.get(key.withSuffix(".negative"));
                if (sprite == null) continue;
                GraySpriteShifterEntry.ALL.put(key, new GraySpriteShifterEntry(sprite, gray, negative));
            }
            ClientUtils.ORIGINAL.clear();
        }
    }

    @SubscribeEvent
    public static void model$ModifyBakingResult(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        ModClientSetups.asCustomModel(modelRegistry, new DeferredHolder[]{AccessoryItems.GUIDE_VOODOO_DOLL, MaterialItems.SOUL_OF_FRIGHT, MaterialItems.SOUL_OF_MIGHT, MaterialItems.SOUL_OF_SIGHT, MaterialItems.SOUL_OF_LIGHT, MaterialItems.SOUL_OF_NIGHT, MaterialItems.SOUL_OF_FLIGHT, MaterialItems.SOUL_OF_BRIGHT, MaterialItems.SOUL_OF_VOIGHT, AxeItems.LUCY_THE_AXE});
        ModClientSetups.asCustomModel(modelRegistry, (DeferredHolder[])TreasureBagItems.ITEMS.getEntries().toArray(DeferredHolder[]::new));
        ModConnectives.MODEL_SWAPPER.onModelBake(modelRegistry);
        if (ModClientSetups.SHOULD_NOT_GENERATE_BLOCK_GRAY_TEXTURE || !StartupConfigs.paintsReplaceTexture()) {
            return;
        }
        CustomBlockModels customBlockModels = ModConnectives.MODEL_SWAPPER.getCustomBlockModels();
        HashSet<? extends String> bannedModForPaints = new HashSet<String>(StartupConfigs.bannedModForPaints());
        for (Map.Entry entry : ((DefaultedMappedRegistry)BuiltInRegistries.BLOCK).byValue.entrySet()) {
            Block block = (Block)entry.getKey();
            ResourceLocation id = ((Holder.Reference)entry.getValue()).key().location();
            if (customBlockModels.containsBlock(block) || bannedModForPaints.contains(id.getNamespace())) continue;
            for (ModelResourceLocation modelLocation : ModelSwapper.getAllBlockStateModelLocations(id, block)) {
                BakedModel bakedModel = (BakedModel)modelRegistry.get(modelLocation);
                if (bakedModel == null) continue;
                modelRegistry.put(modelLocation, new GrayBlockModelSwapper(bakedModel));
            }
        }
    }

    @SubscribeEvent
    public static void registerRecipeBookCategories(RegisterRecipeBookCategoriesEvent event) {
        ModRecipes.TYPES.getEntries().forEach(holder -> event.registerRecipeCategoryFinder((RecipeType)holder.get(), recipeHolder -> RecipeBookCategories.UNKNOWN));
    }

    @SubscribeEvent
    public static void registerRenderBuffers(RegisterRenderBuffersEvent event) {
        for (ColoredGlintContext context : ColoredGlintContext.COLORED_GLINT_CONTEXTS) {
            event.registerRenderBuffer(context.renderType());
        }
    }

    @SubscribeEvent
    public static void registerClientTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(AltImageComponent.class, component -> PrismLibHelper.shouldDisableAltImageTooltip() ? NoopTooltip.INSTANCE : new AltImageTooltip((AltImageComponent)component));
        event.register(RepeaterComponent.class, ClientRepeaterContentsTooltip::new);
    }

    @SubscribeEvent
    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ClientBestiary.getInstance());
        event.registerReloadListener((PreparableReloadListener)LucyTheAxeDialogCategory.Loader.getInstance());
    }

    @SubscribeEvent
    public static void registerCustomBestiaryEntryModel(RegisterCustomBestiaryEntryRendererEvent event) {
        EntityRendererProvider.Context context = event.getContext();
        event.registerBaseWorm(TEMonsterEntities.DEVOURER);
        event.registerBaseWorm(TEMonsterEntities.TOMB_CRAWLER);
        event.registerBaseWorm(TEMonsterEntities.GIANT_WORM);
        event.registerBaseWorm(TEMonsterEntities.LEECH);
        event.registerBoneSerpent(TEMonsterEntities.BONE_SERPENT);
        event.registerBoneSerpent(TEMonsterEntities.WITHER_BONE_SERPENT);
        event.register("entity.minecraft.zombie.slime", new SlimeZombieRenderer(context));
    }

    @SubscribeEvent
    public static void registerItemDecorations(RegisterItemDecorationsEvent event) {
        for (DeferredHolder entry : FishingPoleItems.ITEMS.getEntries()) {
            event.register((ItemLike)entry.get(), ModClientSetups.FISHING_POLE_DECORATOR);
        }
        for (DeferredHolder entry : CrossbowItems.ITEMS.getEntries()) {
            Item item = (Item)entry.get();
            if (!(item instanceof BaseTerraRepeaterItem)) continue;
            event.register((ItemLike)item, ModClientSetups.REPEATER_AMMO);
        }
        if (GroupItem.enable) {
            ResourceLocation plus = Confluence.asResource("plus");
            ResourceLocation minus = Confluence.asResource("minus");
            event.register((ItemLike)GroupItem.getInstance(), (guiGraphics, font, stack, xOffset, yOffset) -> {
                GroupItem.Stacks stacks = (GroupItem.Stacks)stack.get(ModDataComponentTypes.GROUP_STACKS);
                if (stacks != null) {
                    PoseStack pose = guiGraphics.pose();
                    pose.pushPose();
                    pose.translate((float)(xOffset + 9), (float)(yOffset + 9), 200.0f);
                    guiGraphics.blitSprite(stacks.isVisible() ? minus : plus, 0, 0, 7, 7);
                    pose.popPose();
                }
                return false;
            });
        }
    }
}

